using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Collections.Specialized;
using System.Collections.ObjectModel;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon.models;
using VdcUtils;
using System.Configuration;
using System.IO;

namespace UI.WPFClient
{
	public interface IView
	{
		Model Model { get; set; }
	}


	public class ViewBase : UserControl, IView
	{
		protected ILogger Logger { get; private set; }
		protected WindowManager WindowManager { get; private set; }

		public Model Model
		{
			get { return DataContext is Model? (Model)DataContext : null; }
			set { DataContext = value; }
		}

		public ViewBase()
		{
			//Doesn't proceed with the rest of code when design mode occures.
			if (DesignerProperties.GetIsInDesignMode(this)) return;

			Logger = TypeResolver.Instance.Resolve<ILogger>();
			WindowManager = TypeResolver.Instance.Resolve<WindowManager>();
		}

		protected virtual void ModelChanging(Model newValue, Model oldValue)
		{
			if (oldValue != null)
			{
				oldValue.PropertyChanged -= ModelPropertyChanged;
			}

			if (newValue != null)
			{
				newValue.PropertyChanged += ModelPropertyChanged;
			}
		}

		protected virtual void ModelChanged()
		{
		}

		protected override void OnPropertyChanged(DependencyPropertyChangedEventArgs e)
		{
			base.OnPropertyChanged(e);

			if (e.Property == DataContextProperty && e.NewValue != e.OldValue)
			{
                Model newValue = e.NewValue is Model ? (Model)e.NewValue : null;
                Model oldValue = e.OldValue is Model ? (Model)e.OldValue : null;
				ModelChanging(newValue, oldValue);
				ModelChanged();
			}
		}

		protected virtual void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "OpenDocumentation")
			{
				string hashName = ((Model) sender).HashName;
				if (hashName == null)
					return;
				string documentationPath = DocumentationPathTranslator.GetPath(hashName);
				if (documentationPath == null)
					return;
				string path = String.Format("{0}://{1}:{2}/{3}/{4}", App.Scheme, App.Host, App.Port,
				                            ConfigurationManager.AppSettings["DocumentationLibPath"], documentationPath);
				try
				{
					Process.Start(path);
				}
				catch 
				{
				}
			}
			else if(e.PropertyName == "HashName")
			{
				Model model = (Model) sender;
				string hashName = model.HashName;
				if (hashName == null)
				{
					model.OpenDocumentationCommand.IsAvailable = false;
					return;
				}
				string documentationPath = DocumentationPathTranslator.GetPath(hashName);
				if (documentationPath == null)
				{
					model.OpenDocumentationCommand.IsAvailable = false;
					return;
				}

				model.OpenDocumentationCommand.IsAvailable = true;
			}
		}
	}


	public class ListView : ViewBase
	{
		public void List_SelectionChanged(object sender, SelectionChangedEventArgs e)
		{
			ListBox listBox = (ListBox)sender;

			var model = Model as ListModel;
			if (model != null)
			{
				model.SelectedItem = listBox.SelectedItem;
				model.SelectedItems = new ArrayList(listBox.SelectedItems);
			}

			listBox.ReleaseMouseCapture();
		}
	}
}
