﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.configure;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public class UserPortalItemModel : EntityModel
	{
		#region Commands

		private UICommand runCommand;
		public UICommand RunCommand
		{
			get {return runCommand; } 
			private set
			{
				Commands.Remove(runCommand);
				Commands.Add(value);
				runCommand = value;
			}
		}

		private UICommand pauseCommand;
		public UICommand PauseCommand
		{
			get { return pauseCommand; }
			private set
			{
				Commands.Remove(pauseCommand);
				Commands.Add(value);
				pauseCommand = value;
			}
		}

		private UICommand stopCommand;
		public UICommand StopCommand
		{
			get { return stopCommand; }
			private set
			{
				Commands.Remove(stopCommand);
				Commands.Add(value);
				stopCommand = value;
			}
		}

		private UICommand shutdownCommand;
		public UICommand ShutdownCommand
		{
			get { return shutdownCommand; }
			private set
			{
				Commands.Remove(shutdownCommand);
				Commands.Add(value);
				shutdownCommand = value;
			}
		}

		private UICommand retrieveCdImagesCommand;
		public UICommand RetrieveCdImagesCommand
		{
			get { return retrieveCdImagesCommand; }
			private set
			{
				Commands.Remove(retrieveCdImagesCommand);
				Commands.Add(value);
				retrieveCdImagesCommand = value;
			}
		}

		private UICommand takeVmCommand;
		public UICommand TakeVmCommand
		{
			get { return takeVmCommand; }
			private set
			{
				Commands.Remove(takeVmCommand);
				Commands.Add(value);
				takeVmCommand = value;
			}
		}

		private UICommand returnVmCommand;
		public UICommand ReturnVmCommand
		{
			get { return returnVmCommand; }
			private set
			{
				Commands.Remove(returnVmCommand);
				Commands.Add(value);
				returnVmCommand = value;
			}
		}

		#endregion

		#region Properties

		public IVmPoolResolutionService ResolutionService { get; private set; }


		private string name;
		public string Name
		{
			get { return name; }
			set
			{
				if (name != value)
				{
					name = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Name"));
				}
			}
		}

		private string description;
		public string Description
		{
			get { return description; }
			set
			{
				if (description != value)
				{
					description = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Description"));
				}
			}
		}

		private bool isPool;
		public bool IsPool
		{
			get { return isPool; }
			set
			{
				if (isPool != value)
				{
					isPool = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsPool"));
				}
			}
		}

		private bool isServer;
		public bool IsServer
		{
			get { return isServer; }
			set
			{
				if (isServer != value)
				{
					isServer = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsServer"));
				}
			}
		}

		private bool isFromPool;
		public bool IsFromPool
		{
			get { return isFromPool; }
			set
			{
				if (isFromPool != value)
				{
					isFromPool = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsFromPool"));
				}
			}
		}

		private VmPoolType poolType;
		public VmPoolType PoolType
		{
			get { return poolType; }
			set
			{
				if (poolType != value)
				{
					poolType = value;
					OnPropertyChanged(new PropertyChangedEventArgs("PoolType"));
				}
			}
		}

		private VMStatus status;
		public VMStatus Status
		{
			get { return status; }
			set
			{
				if (status != value)
				{
					status = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Status"));
				}
			}
		}

		private ConsoleModel defaultConsole;
		public ConsoleModel DefaultConsole
		{
			get { return defaultConsole; }
			set
			{
				if (defaultConsole != value)
				{
					defaultConsole = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefaultConsole"));
				}
			}
		}

		private ConsoleModel additionalConsole;
		public ConsoleModel AdditionalConsole
		{
			get { return additionalConsole; }
			set
			{
				if (additionalConsole != value)
				{
					additionalConsole = value;
					OnPropertyChanged(new PropertyChangedEventArgs("AdditionalConsole"));
				}
			}
		}

		private bool hasAdditionalConsole;
		public bool HasAdditionalConsole
		{
			get { return hasAdditionalConsole; }
			set
			{
				if (hasAdditionalConsole != value)
				{
					hasAdditionalConsole = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasAdditionalConsole"));
				}
			}
		}

		private IList<ChangeCDModel> cdImages;
		public IList<ChangeCDModel> CdImages
		{
			get { return cdImages; }
			set
			{
				if (cdImages != value)
				{
					cdImages = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CdImages"));
				}
			}
		}

		private VmOsType osType;
		public VmOsType OsType
		{
			get { return osType; }
			set
			{
				if (osType != value)
				{
					osType = value;
					OnPropertyChanged(new PropertyChangedEventArgs("OsType"));
				}
			}
		}

		public bool IsFromAutomaticPool
		{
			get { return IsFromPool && PoolType == VmPoolType.Automatic; }
		}

		#endregion


		private ItemBehavior behavior;


		public UserPortalItemModel(IVmPoolResolutionService resolutionService)
		{
			ResolutionService = resolutionService;

			RunCommand = new UICommand("Run", this);
			PauseCommand = new UICommand("Pause", this);
			StopCommand = new UICommand("Stop", this);
			ShutdownCommand = new UICommand("Shutdown", this);
			RetrieveCdImagesCommand = new UICommand("RetrieveCdImages", this);
			TakeVmCommand = new UICommand("TakeVm", this);
			ReturnVmCommand = new UICommand("ReturnVm", this);

			CdImages =
				new List<ChangeCDModel>
				{
					new ChangeCDModel { Title = "Retrieving CDs..." }
				};
		}

		protected override void OnEntityChanged()
		{
			//Change behavior to match entity type.
			if (Entity is VM)
			{
				behavior = new VmItemBehavior(this);
			}
			else if (Entity is vm_pools)
			{
				behavior = new PoolItemBehavior(this);
			}
			else
			{
				throw new NotSupportedException();
			}

			behavior.OnEntityChanged();
		}

		public bool IsVmUp()
		{
			switch (Status)
			{
				case VMStatus.WaitForLaunch:
				case VMStatus.PoweringUp:
				case VMStatus.RebootInProgress:
				case VMStatus.RestoringState:
				case VMStatus.MigratingFrom:
				case VMStatus.MigratingTo:
				case VMStatus.Up:
					return true;

				default:
					return false;
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);
			behavior.EntityPropertyChanged(e);
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);
			behavior.eventRaised(ev, sender, args);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);
			behavior.ExecuteCommand(command);
		}
	}
}
