using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.VdcQueries;

namespace org.ovirt.engine.ui.uicommon.models.templates
{
	public class ImportTemplateModel : ListWithDetailsModel
	{
		#region Properties

		public storage_domain_static SourceStorage { get; set; }
		public storage_pool StoragePool { get; set; }

		public ListModel DestinationStorage { get; private set; }
		public ListModel Cluster { get; private set; }

		private string nameAndDescription;
		public string NameAndDescription
		{
			get { return nameAndDescription; }
			set
			{
				if (nameAndDescription != value)
				{
					nameAndDescription = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NameAndDescription"));
				}
			}
		}

		#endregion

		public ImportTemplateModel()
		{
			DestinationStorage = new ListModel();
			Cluster = new ListModel();
		}

		protected override void InitDetailModels()
		{
			base.InitDetailModels();

			ObservableCollection<EntityModel> list = new ObservableCollection<EntityModel>();
			list.Add(new TemplateGeneralModel());
			list.Add(new TemplateImportInterfaceListModel());
			list.Add(new TemplateImportDiskListModel());
			DetailModels = list;
		}

		internal bool Validate()
		{
			DestinationStorage.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			Cluster.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			return DestinationStorage.IsValid
				   && Cluster.IsValid;
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			if (SelectedItem != null)
			{
				KeyValuePair<VmTemplate, List<DiskImage>> selectedItem = (KeyValuePair<VmTemplate, List<DiskImage>>)SelectedItem;
				VmTemplate template = selectedItem.Key;
				NameAndDescription = string.Format("{0}{1}", template.name, !string.IsNullOrEmpty(template.description) ? " [" + template.description + "]" : string.Empty);
			}
			else
			{
				NameAndDescription = string.Empty;
			}

		}
	}
}
