﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace org.ovirt.engine.ui.uicommon.models
{
	public class ListWithDetailsModel : SearchableListModel
	{
		#region Properties

		private IList<EntityModel> detailModels;
		public IList<EntityModel> DetailModels
		{
			get { return detailModels; }
			set
			{
				if (detailModels != value)
				{
					detailModels = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DetailModels"));
				}
			}
		}

		private EntityModel activeDetailModel;
		public EntityModel ActiveDetailModel
		{
			get
			{
				return activeDetailModel;
			}
			set
			{
				if (activeDetailModel != value)
				{
					ActiveDetailModelChanging(value, ActiveDetailModel);
					activeDetailModel = value;
					ActiveDetailModelChanged();
					OnPropertyChanged(new PropertyChangedEventArgs("ActiveDetailModel"));
				}
			}
		}

		private bool detailModelsInitialized;

		#endregion

		protected virtual void InitDetailModels()
		{
		}

		protected virtual void UpdateDetailsAvailability()
		{
		}

		private void ActiveDetailModelChanging(EntityModel newValue, EntityModel oldValue)
		{
			//Make sure we had set an entity property of details model.
			if (oldValue != null)
			{
				oldValue.Entity = null;

				if (oldValue is SearchableListModel)
				{
					((SearchableListModel)oldValue).EnsureAsyncSearchStopped();
				}
			}

			if (newValue != null)
			{
				newValue.Entity = ProvideDetailModelEntity(SelectedItem);
			}
		}

		protected virtual object ProvideDetailModelEntity(object selectedItem)
		{
			return selectedItem;
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();

			if (SelectedItem != null)
			{
				//Initialize detail models on demand, just after some item was selected.
				if (!detailModelsInitialized)
				{
					InitDetailModels();
					detailModelsInitialized = true;
				}
				//Try to choose default (first) detail model.
				UpdateDetailsAvailability();
				if (DetailModels != null)
				{
					if ((ActiveDetailModel != null && !ActiveDetailModel.IsAvailable) || ActiveDetailModel == null)
					{
						//ActiveDetailModel = DetailModels.FirstOrDefault(AvailabilityDecorator.GetIsAvailable);
						EntityModel model = null;
						foreach (EntityModel item in DetailModels)
						{
							if (item.IsAvailable)
							{
								model = item;
								break;
							}
						}
						ActiveDetailModel = model;
					}
				}

				//if (DetailModels != null && ActiveDetailModel == null)
				//{
				//    ActiveDetailModel = DetailModels.FirstOrDefault();
				//}
			}
			else
			{
				//If selected item become null, make sure we stop all activity on an active detail model.
				if (ActiveDetailModel != null && ActiveDetailModel is SearchableListModel)
				{
					((SearchableListModel)ActiveDetailModel).EnsureAsyncSearchStopped();
				}
			}

			//Syncronise selected item with the entity of an active details model.
			if (ActiveDetailModel != null)
			{
				ActiveDetailModel.Entity = ProvideDetailModelEntity(SelectedItem);
			}
		}

		protected virtual void ActiveDetailModelChanged()
		{
		}

		internal override void EnsureAsyncSearchStopped()
		{
			base.EnsureAsyncSearchStopped();

			if (DetailModels != null)
			{
				//Stop search on all list models.
				foreach (EntityModel model in DetailModels)
				{
					if (model is SearchableListModel)
					{
						SearchableListModel listModel = (SearchableListModel)model;
						listModel.EnsureAsyncSearchStopped();
					}
				}
			}
		}
	}
}
