using System;
using System.Collections.Generic;
using System.Text;
using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class VdsConditionFieldAutoCompleter : BaseConditionFieldAutoCompleter
    {
        public VdsConditionFieldAutoCompleter()
            :
            base()
        {
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("STATUS", "STATUS");
            mVerbs.Add("CLUSTER", "CLUSTER");
            mVerbs.Add("ADDRESS", "ADDRESS");
            mVerbs.Add("CPU_USAGE", "CPU_USAGE");
            mVerbs.Add("MEM_USAGE", "MEM_USAGE");
            mVerbs.Add("NETWORK_USAGE", "NETWORK_USAGE");
            mVerbs.Add("LOAD", "LOAD");
            mVerbs.Add("VERSION", "VERSION");
            mVerbs.Add("CPUS", "CPUS");
            mVerbs.Add("MEMORY", "MEMORY");
            mVerbs.Add("CPU_SPEED", "CPU_SPEED");
            mVerbs.Add("CPU_MODEL", "CPU_MODEL");
            mVerbs.Add("ACTIVE_VMS", "ACTIVE_VMS");
            mVerbs.Add("MIGRATING_VMS", "MIGRATING_VMS");
			mVerbs.Add("COMMITTED_MEM", "COMMITTED_MEM");
			mVerbs.Add("TAG", "TAG");
			mVerbs.Add("TYPE", "TYPE");
			mVerbs.Add("DATACENTER", "DATACENTER");
            //mVerbs.Add("NOTE", "NOTE");
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("STATUS", typeof(VDSStatus));
            TypeDictionary.Add("CLUSTER", typeof(string));
            TypeDictionary.Add("ADDRESS", typeof(string));
            TypeDictionary.Add("CPU_USAGE", typeof(int));
            TypeDictionary.Add("MEM_USAGE", typeof(int));
            TypeDictionary.Add("NETWORK_USAGE", typeof(int));
            TypeDictionary.Add("LOAD", typeof(decimal));
            TypeDictionary.Add("VERSION", typeof(string));
            TypeDictionary.Add("CPUS", typeof(int));
            TypeDictionary.Add("MEMORY", typeof(int));
            TypeDictionary.Add("CPU_SPEED", typeof(decimal));
            TypeDictionary.Add("CPU_MODEL", typeof(string));
            TypeDictionary.Add("ACTIVE_VMS", typeof(int));
            TypeDictionary.Add("MIGRATING_VMS", typeof(int));
			TypeDictionary.Add("COMMITTED_MEM", typeof(int));
			TypeDictionary.Add("TAG", typeof(string));
			TypeDictionary.Add("TYPE", typeof(VDSNiceType));
			TypeDictionary.Add("DATACENTER", typeof(string));
            //mTypeDict.Add("NOTE", typeof(string));
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "vds_name");
            mColumnNameDict.Add("STATUS", "status");
            mColumnNameDict.Add("CLUSTER", "vds_group_name");
            mColumnNameDict.Add("ADDRESS", "host_name");
            mColumnNameDict.Add("CPU_USAGE", "usage_cpu_percent");
            mColumnNameDict.Add("MEM_USAGE", "usage_mem_percent");
            mColumnNameDict.Add("NETWORK_USAGE", "usage_network_percent");
            mColumnNameDict.Add("LOAD", "cpu_load");
            mColumnNameDict.Add("VERSION", "software_version");
            mColumnNameDict.Add("CPUS", "cpu_cores");
            mColumnNameDict.Add("MEMORY", "physical_mem_mb");
            mColumnNameDict.Add("CPU_SPEED","cpu_speed_mh");
            mColumnNameDict.Add("CPU_MODEL", "cpu_model");
            mColumnNameDict.Add("ACTIVE_VMS", "vm_active");
            mColumnNameDict.Add("MIGRATING_VMS", "vm_migrating");
			mColumnNameDict.Add("COMMITTED_MEM", "mem_commited");
			mColumnNameDict.Add("TAG", "tag_name");
			mColumnNameDict.Add("TYPE", "vds_type");
			mColumnNameDict.Add("DATACENTER", "storage_pool_name");
            //mColumnNameDict.Add("NOTE", "note");
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
            IAutoCompleter retval = null;
            switch (fieldName)
            {
                case "MEMORY":
                case "CPUS":
                case "CPU_USAGE":
                case "MEM_USAGE":
                case "LOAD":
                case "CPU_SPEED":
                case "ACTIVE_VMS":
                case "NETWORK_USAGE":
				case "COMMITTED_MEM":
                    retval = new NumericConditionRelationAutoCompleter();
                    break;
				case "TAG":
					retval = new StringOnlyEqualConditionRelationAutoCompleter();
					break;
                default:
                    retval = new StringConditionRelationAutoCompleter();
                    break;
            }
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "STATUS":
                    retval = new EnumValueAutoCompleter(typeof(VDSStatus));
                    break;
				case "TYPE":
					retval = new EnumValueAutoCompleter(typeof(VDSNiceType));
					break;
				default:
                    break;
            }
            return retval;
        }
    }
}
