using System;
using System.Collections.Generic;
using System.Text;

namespace SearchBackend
{
    class DateEnumValueAutoCompleter : BaseAutoCompleter, IConditionValueAutoCompleter
    {
        Dictionary<string, int> mEnumValues = new Dictionary<string, int>();
        public DateEnumValueAutoCompleter(Type enumerationType)
            : base()
        {
           foreach(int val in Enum.GetValues(enumerationType))
           {
               string ValName = Enum.GetName(enumerationType, val).ToUpper();
               mEnumValues.Add(ValName, val);
               mVerbs.Add(ValName, ValName);
           }
           AddDaysOfWeek();
           buildCompletions();
        }

        private void AddDaysOfWeek()
        {
            string day;
            int dayIndex = 3;
            for (int i = -2; i > -8; i--)
            {
                day = DateTime.Now.AddDays(i).DayOfWeek.ToString();
                mEnumValues.Add(day, dayIndex);
                mVerbs.Add(day, day);
                dayIndex++;
            }

        }

        public string convertFieldEnumValueToActualValue(string fieldValue)
        {
            DateTime result;
            if (DateTime.TryParse(fieldValue, out result))
            {
                return fieldValue;
            }
            else
            {
                //check enum values
                string retval = string.Empty;
                if (mEnumValues.ContainsKey(fieldValue.ToUpper()))
                {
                    return retval = mEnumValues[fieldValue.ToUpper()].ToString();
                }
                //check for rest of the week
                foreach (DayOfWeek day in Enum.GetValues(typeof(DayOfWeek)))
                {
                    if (fieldValue.ToUpper() == day.ToString().ToUpper())
                    {
                        return fieldValue;
                    }
                }
            }
            return "";
            
        }
    }
}
