﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
    public partial class StoragePoolParametersBase : VdcActionParametersBase
    {
        public StoragePoolParametersBase() { }

        public StoragePoolParametersBase(Guid storagePoolId)
        {
            StoragePoolId = storagePoolId;
        }
    }

    public partial class StoragePoolManagementParameter : StoragePoolParametersBase
    {
        public StoragePoolManagementParameter() { }

        public StoragePoolManagementParameter(storage_pool storagePool)
            : base(storagePool.Id)
        {
            StoragePool = storagePool;
        }
    }
    public partial class StoragePoolWithStoragesParameter : StoragePoolManagementParameter
    {
        public StoragePoolWithStoragesParameter() { }

        public StoragePoolWithStoragesParameter(storage_pool storagePool, 
            List<Guid> storage_domain_ids) : base(storagePool)
        {
            Storages = storage_domain_ids.ToArray();
        }
    }
    public partial class StorageDomainParametersBase : StoragePoolParametersBase
    {
        public StorageDomainParametersBase (Guid storageDomainId) : base(Guid.Empty)
        {
            StorageDomainId = storageDomainId;
        }
        public StorageDomainParametersBase()
        {
        }
    }

    public partial class RemoveStorageDomainParameters : StorageDomainParametersBase
    {
		public RemoveStorageDomainParameters(){}
        public RemoveStorageDomainParameters(Guid storageDomainId) : base(storageDomainId)
        {
        }
    }

    public partial class StorageDomainPoolParametersBase : StorageDomainParametersBase
    {
        public StorageDomainPoolParametersBase() { }
        public StorageDomainPoolParametersBase(Guid storageId, Guid storagePoolId) : base(storageId)
        {
            StoragePoolId = storagePoolId;
        }
    }
    
    public partial class DetachStorageDomainFromPoolParameters :  StorageDomainPoolParametersBase
    {
        public DetachStorageDomainFromPoolParameters() { }
        public DetachStorageDomainFromPoolParameters(Guid storageId, Guid storagePoolId) : base(storageId, storagePoolId)
        {
        }
    }
    
    public partial class StorageDomainManagementParameter :  StorageDomainParametersBase
    {
        public StorageDomainManagementParameter() { }
       
        public StorageDomainManagementParameter(storage_domain_static storageDomain) : base(storageDomain.Id)
        {
            StorageDomain = storageDomain;
            VdsId = Guid.Empty;
        }
    }
    
    public partial class AddSANStorageDomainParameters : StorageDomainManagementParameter
    {
   
        public AddSANStorageDomainParameters() { }

        public AddSANStorageDomainParameters(storage_domain_static storageDomain) : base(storageDomain)
        {
        }
    }
    
    public partial class ExtendSANStorageDomainParameters : StorageDomainParametersBase
    {
        public ExtendSANStorageDomainParameters() { }
        public ExtendSANStorageDomainParameters(Guid storageDomainId, List<string> lunIds)
            : base(storageDomainId)
        {
            LunIds = lunIds.ToArray();
        }
    }
    
    public partial class StorageServerConnectionParametersBase : StoragePoolParametersBase
    {
      
        public StorageServerConnectionParametersBase() { }

        public StorageServerConnectionParametersBase(storage_server_connections connection, Guid vdsId) :
            base(Guid.Empty)
        {
            StorageServerConnection = connection;
            VdsId = vdsId;
        }
    }
    
    public partial class RemoveVgParameters : StoragePoolParametersBase
    {
  
        public RemoveVgParameters() { }

        public RemoveVgParameters(string vgId) : base(Guid.Empty)
        {
            VgId = vgId;
        }
    }

     
    public partial class FenceVdsManualyParameters : StoragePoolParametersBase
    {
    
        public FenceVdsManualyParameters() { }

        public FenceVdsManualyParameters(bool clearVMs)
            : base(Guid.Empty)
        {
            ClearVMs = clearVMs;
        }
    }

    
    public partial class AddNetworkStoragePoolParameters : StoragePoolParametersBase
    {
        public AddNetworkStoragePoolParameters() { }

        public AddNetworkStoragePoolParameters(Guid storagePoolId, network net) 
            : base(storagePoolId)
        {
            Network = net;
        }
    }

    
    public partial class ReconstructMasterParameters : StorageDomainPoolParametersBase
    {
        public ReconstructMasterParameters(){}
        public ReconstructMasterParameters(Guid storagePoolId, Guid storageDomainId, bool isDeactivate) 
            : base(storageDomainId, storagePoolId)
        {
            IsDeactivate = isDeactivate;
        }
    }
    
    public partial class RecoveryStoragePoolParameters : ReconstructMasterParameters
    {
		public RecoveryStoragePoolParameters(){}
        public RecoveryStoragePoolParameters(Guid storagePoolId, Guid newMasterDomainId)
            : base(storagePoolId, Guid.Empty, false)
        {
            NewMasterDomainId = newMasterDomainId;
        }
    }
}
