using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.models.templates;
using org.ovirt.engine.ui.uicommon.models.configure;

namespace UI.WPFClient
{
	public partial class TemplateListView
	{
		private WindowView view;

		public new TemplateListModel Model
		{
			get { return base.Model as TemplateListModel; }
			set { base.Model = value; }
		}

		public TemplateListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.EditCommand)
				{
					view = TypeResolver.Instance.Resolve<TemplateView>();
				}
				else if (Model.LastExecutedCommand == Model.RemoveCommand)
				{
					view = TypeResolver.Instance.Resolve<RemoveView>();
				}
				else if (Model.LastExecutedCommand == Model.ExportCommand)
				{
					view = TypeResolver.Instance.Resolve<ExportTemplateView>();
				}
				else if (Model.LastExecutedCommand == Model.CopyCommand)
				{
					view = TypeResolver.Instance.Resolve<FindSingleStorageView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}
	}
}
