﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Collections;

namespace UI.WPFClient
{
	public class ChartAxisTick : DependencyObject
	{
		#region Properties

		public double Position
		{
			get { return (double)GetValue(PositionProperty); }
			set { SetValue(PositionProperty, value); }
		}
		public static readonly DependencyProperty PositionProperty =
			DependencyProperty.Register("Position", typeof(double), typeof(ChartAxisTick));


		public object Value
		{
			get { return GetValue(ValueProperty); }
			set { SetValue(ValueProperty, value); }
		}
		public static readonly DependencyProperty ValueProperty =
			DependencyProperty.Register("Value", typeof(object), typeof(ChartAxisTick), new UIPropertyMetadata(null));

		#endregion
	}


	public abstract class ChartAxis : Control
	{
		#region Properties

		public object Minimum
		{
			get { return GetValue(MinimumProperty); }
			set { SetValue(MinimumProperty, value); }
		}
		public static readonly DependencyProperty MinimumProperty =
			DependencyProperty.Register("Minimum", typeof(object), typeof(ChartAxis), new UIPropertyMetadata(null, MinimumChanged));

		private static void MinimumChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			ChartAxis instance = (ChartAxis)d;
			instance.MinimumChanged();
		}


		public object Maximum
		{
			get { return GetValue(MaximumProperty); }
			set { SetValue(MaximumProperty, value); }
		}
		public static readonly DependencyProperty MaximumProperty =
			DependencyProperty.Register("Maximum", typeof(object), typeof(ChartAxis), new UIPropertyMetadata(null, MaximumChanged));

		private static void MaximumChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			ChartAxis instance = (ChartAxis)d;
			instance.MaximumChanged();
		}


		public object TickInterval
		{
			get { return GetValue(TickIntervalProperty); }
			set { SetValue(TickIntervalProperty, value); }
		}
		public static readonly DependencyProperty TickIntervalProperty =
			DependencyProperty.Register("TickInterval", typeof(object), typeof(ChartAxis), new UIPropertyMetadata(null, TickIntervalChanged));

		private static void TickIntervalChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			ChartAxis instance = (ChartAxis)d;
			instance.TickIntervalChanged();
		}


		public int TickCount
		{
			get { return (int)GetValue(TickCountProperty); }
			set { SetValue(TickCountProperty, value); }
		}
		public static readonly DependencyProperty TickCountProperty =
			DependencyProperty.Register("TickCount", typeof(int), typeof(ChartAxis), new UIPropertyMetadata(0, TickCountChanged));

		private static void TickCountChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			ChartAxis instance = (ChartAxis)d;
			instance.TickCountChanged();
		}

		public IEnumerable<ChartAxisTick> Ticks
		{
			get { return (IEnumerable<ChartAxisTick>)GetValue(TicksProperty); }
			set { SetValue(TicksProperty, value); }
		}
		public static readonly DependencyProperty TicksProperty =
			DependencyProperty.Register("Ticks", typeof(IEnumerable<ChartAxisTick>), typeof(ChartAxis), new UIPropertyMetadata(null));

		#endregion

		protected virtual void MinimumChanged()
		{
		}

		protected virtual void MaximumChanged()
		{
		}

		protected virtual void TickIntervalChanged()
		{
		}

		protected virtual void TickCountChanged()
		{
		}

		public abstract double CalculatePosition(object value);
	}


	//public class TimeAxis : ChartAxis
	//{
	//    protected override void MinimumChanged()
	//    {
	//        base.MinimumChanged();
	//        UpdateTicks();
	//    }

	//    protected override void MaximumChanged()
	//    {
	//        base.MaximumChanged();
	//        UpdateTicks();
	//    }

	//    protected override void TickIntervalChanged()
	//    {
	//        base.TickIntervalChanged();
	//        UpdateTicks();
	//    }

	//    private void UpdateTicks()
	//    {
	//        if (Minimum != null && Maximum != null && TickInterval != null)
	//        {
	//            DateTime min = (DateTime)Minimum;
	//            DateTime max = (DateTime)Maximum;
	//            TimeSpan interval = (TimeSpan)TickInterval;

	//            int r = Convert.ToInt32((max.Ticks - min.Ticks) / interval.Ticks);
	//            if (r > 0)
	//            {
	//                Ticks = Enumerable.Range(1, r - 1)
	//                    .Select(
	//                        delegate(int index)
	//                        {
	//                            DateTime value = new DateTime(min.Ticks + interval.Ticks * index);

	//                            return
	//                                new ChartAxisTick
	//                                {
	//                                    Value = value,
	//                                    Position = CalculatePosition(value)
	//                                };
	//                        })
	//                    .ToList();
	//            }
	//            else
	//            {
	//                Ticks = null;
	//            }
	//        }
	//    }

	//    //public override void Scale(double factor)
	//    //{
	//    //    base.Scale(factor);

	//    //    DateTime min = (DateTime)Minimum;
	//    //    DateTime max = (DateTime)Maximum;

	//    //    double r = max.Ticks - min.Ticks;
	//    //    Maximum = new DateTime(min.Ticks + Convert.ToInt64(r * factor));
	//    //}

	//    public override double CalculatePosition(object value)
	//    {
	//        DateTime min = (DateTime)Minimum;
	//        DateTime max = (DateTime)Maximum;
	//        DateTime val = (DateTime)value;

	//        double step = 1.0 / (max.Ticks - min.Ticks);

	//        return step * val.Ticks - step * min.Ticks;
	//    }

	//    //public override bool IsOverMaximum(object value)
	//    //{
	//    //    DateTime max = (DateTime)Maximum;
	//    //    DateTime val = (DateTime)value;

	//    //    return val >= max;
	//    //}
	//}


	public class NumberAxis : ChartAxis
	{
		protected override void MinimumChanged()
		{
			base.MinimumChanged();
			UpdateTicks();
		}

		protected override void MaximumChanged()
		{
			base.MaximumChanged();
			UpdateTicks();
		}

		protected override void TickIntervalChanged()
		{
			base.TickIntervalChanged();
			UpdateTicks();
		}

		protected override void TickCountChanged()
		{
			base.TickCountChanged();
			UpdateTicks();
		}

		private void UpdateTicks()
		{
			if (Minimum != null && Maximum != null)
			{
				double min = Convert.ToDouble(Minimum);
				double max = Convert.ToDouble(Maximum);

				if (TickInterval != null && TickCount == 0)
				{
					double interval = (double)TickInterval;

					int r = Convert.ToInt32((max - min) / interval);
					if (r > 0)
					{
						Ticks = Enumerable.Range(1, r - 1)
							.Select(
								delegate(int index)
								{
									double value = min + interval * index;
									return
										new ChartAxisTick
										{
											Value = value,
											Position = CalculatePosition(value)
										};
								})
							.ToList();
					}
					else
					{
						Ticks = null;
					}
				}

				if (TickCount > 0 && TickInterval == null)
				{
					int r = Convert.ToInt32((max - min) / TickCount);
					if (r > 0)
					{
						Ticks = Enumerable.Range(1, TickCount - 1)
							.Select(
								delegate(int index)
								{
									double value = min + r * index;
									return
										new ChartAxisTick
										{
											Value = value,
											Position = CalculatePosition(value)
										};
								})
							.ToList();
					}
					else
					{
						Ticks = null;
					}
				}
			}
		}

		public override double CalculatePosition(object value)
		{
			double min = Convert.ToDouble(Minimum);
			double max = Convert.ToDouble(Maximum);
			double val = (double)value;

			double step = 1.0 / (max - min);

			return step * val - step * min;
		}
	}
}
