using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models
{
	public class EntityModel : Model
	{
		#region Events

		public static EventDefinition EntityChangedEventDefinition;
		public Event EntityChangedEvent { get; private set; }

		#endregion

		#region Properties

		private object entity;
		public object Entity
		{
			get { return entity; }
			set
			{
				bool isNewValue = false;
				if (entity != null)
				{
					isNewValue = !entity.Equals(value);
				}
				else if (value != null)
				{
					isNewValue = true;
				}

				if (isNewValue)
				{
					EntityChanging(value, entity);
					entity = value;
					OnEntityChanged();
					EntityChangedEvent.raise(this, EventArgs.Empty);
					OnPropertyChanged(new PropertyChangedEventArgs("Entity"));
				}
			}
		}

		#endregion

		static EntityModel()
		{
			EntityChangedEventDefinition = new EventDefinition("EntityChanged", typeof(EntityModel));
		}

		public EntityModel()
		{
			EntityChangedEvent = new Event(EntityChangedEventDefinition);
		}

		protected virtual void EntityChanging(object newValue, object oldValue)
		{
			IProvidePropertyChangedEvent notifier = oldValue as IProvidePropertyChangedEvent;
			if (notifier != null)
			{
				notifier.PropertyChangedEvent.removeListener(this);
			}

			notifier = newValue as IProvidePropertyChangedEvent;
			if (notifier != null)
			{
				notifier.PropertyChangedEvent.addListener(this);
			}
		}

		protected virtual void OnEntityChanged()
		{
		}

		/// <summary>
		/// Invoked whenever some property of the entity was changed.
		/// </summary>
		protected virtual void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(EntityChangedEventDefinition))
			{
				OnEntityChanged();
			}
			else if (ev.Equals(ProvidePropertyChangedEvent.Definition))
			{
				EntityPropertyChanged(sender, (PropertyChangedEventArgs)args);
			}
		}


		public void ValidateEntity(IValidation[] validations)
		{
			IsValid = true;

			if (!IsAvailable || !IsChangable)
			{
				return;
			}

			foreach (IValidation validation in validations)
			{
				ValidationResult result = validation.Validate(Entity);
				if (!result.Success)
				{
					foreach (string reason in result.Reasons)
					{
						InvalidityReasons.Add(reason);
					}
					IsValid = false;

					break;
				}
			}
		}
	}
}
