PRINT 'Processing vm_template_image_map_sp.sql'

----------------------------------------------------------------
-- [dbo].[vm_template_image_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVmTemplateImageMap')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVmTemplateImageMap] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVmTemplateImageMap]
    @internal_drive_mapping varchar(50),
	@it_guid uniqueidentifier,
	@vmt_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_template_image_map] ([internal_drive_mapping], [it_guid], [vmt_guid])
	VALUES (@internal_drive_mapping, @it_guid, @vmt_guid)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmTemplateImageMap')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmTemplateImageMap] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmTemplateImageMap]
    @internal_drive_mapping varchar(50),
	@it_guid uniqueidentifier,
	@vmt_guid uniqueidentifier
AS
BEGIN

	--The [dbo].[vm_template_image_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_template_image_map] 
	SET [internal_drive_mapping] = @internal_drive_mapping
	WHERE [it_guid]=@it_guid AND [vmt_guid]=@vmt_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVmTemplateImageMap')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVmTemplateImageMap] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVmTemplateImageMap]
	 @it_guid uniqueidentifier,
	@vmt_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			DELETE FROM [dbo].[vm_template_image_map]
			WHERE [it_guid]=@it_guid AND [vmt_guid]=@vmt_guid

			DELETE FROM [dbo].[image_templates]
			WHERE [it_guid]=@it_guid
			
			DELETE FROM [dbo].[images]
			WHERE [image_guid]=@it_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVmTemplateImageMap')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVmTemplateImageMap] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVmTemplateImageMap]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_template_image_map].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_template_image_map].[it_guid] AS 'it_guid',
		[vm_template_image_map].[vmt_guid] AS 'vmt_guid'
	FROM [dbo].[vm_template_image_map] [vm_template_image_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateImageMapByItGuidAndByVmtGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplateImageMapByItGuidAndByVmtGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateImageMapByItGuidAndByVmtGuid] 
	@it_guid uniqueidentifier,
	@vmt_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_template_image_map].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_template_image_map].[it_guid] AS 'it_guid',
		[vm_template_image_map].[vmt_guid] AS 'vmt_guid'
		FROM [dbo].[vm_template_image_map] [vm_template_image_map]
		WHERE [it_guid]=@it_guid AND [vmt_guid]=@vmt_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


