PRINT 'Processing vm_template_disk_sp.sql'

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateDiskByVmtGuidAndItGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplateDiskByVmtGuidAndItGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateDiskByVmtGuidAndItGuid] 
	@vmt_guid uniqueidentifier,
	@it_guid  uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_template_disk].[vtim_it_guid] AS 'vtim_it_guid',
		[vm_template_disk].[vmt_guid] AS 'vmt_guid',
		[vm_template_disk].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_template_disk].[it_guid] AS 'it_guid',
		[vm_template_disk].[os] AS 'os',
		[vm_template_disk].[os_version] AS 'os_version',
		[vm_template_disk].[creation_date] AS 'creation_date',
		[vm_template_disk].[size] AS 'size',
		[vm_template_disk].[bootable] AS 'bootable',
		[vm_template_disk].[description] AS 'description'
		
		FROM [dbo].[vm_template_disk] [vm_template_disk]
		WHERE [vmt_guid]=@vmt_guid AND [it_guid] = @it_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateDisksByVmtGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplateDisksByVmtGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateDisksByVmtGuid] 
	@vmt_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_template_disk].[vtim_it_guid] AS 'vtim_it_guid',
		[vm_template_disk].[vmt_guid] AS 'vmt_guid',
		[vm_template_disk].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_template_disk].[it_guid] AS 'it_guid',
		[vm_template_disk].[os] AS 'os',
		[vm_template_disk].[os_version] AS 'os_version',
		[vm_template_disk].[creation_date] AS 'creation_date',
		[vm_template_disk].[size] AS 'size',
		[vm_template_disk].[bootable] AS 'bootable',
		[vm_template_disk].[description] AS 'description'
		FROM [dbo].[vm_template_disk] [vm_template_disk]
		WHERE [vmt_guid]=@vmt_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateDisksByImageTemplateGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].GetVmTemplateDisksByImageTemplateGuid AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateDisksByImageTemplateGuid] 
	@it_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_template_disk].[vtim_it_guid] AS 'vtim_it_guid',
		[vm_template_disk].[vmt_guid] AS 'vmt_guid',
		[vm_template_disk].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_template_disk].[it_guid] AS 'it_guid',
		[vm_template_disk].[os] AS 'os',
		[vm_template_disk].[os_version] AS 'os_version',
		[vm_template_disk].[creation_date] AS 'creation_date',
		[vm_template_disk].[size] AS 'size',
		[vm_template_disk].[bootable] AS 'bootable',
		[vm_template_disk].[description] AS 'description'
		FROM [dbo].[vm_template_disk] [vm_template_disk]
		WHERE [it_guid]=@it_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllVmTemplateDisks')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllVmTemplateDisks] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllVmTemplateDisks] 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_template_disk].[vtim_it_guid] AS 'vtim_it_guid',
		[vm_template_disk].[vmt_guid] AS 'vmt_guid',
		[vm_template_disk].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_template_disk].[it_guid] AS 'it_guid',
		[vm_template_disk].[os] AS 'os',
		[vm_template_disk].[os_version] AS 'os_version',
		[vm_template_disk].[creation_date] AS 'creation_date',
		[vm_template_disk].[size] AS 'size',
		[vm_template_disk].[bootable] AS 'bootable',
		[vm_template_disk].[description] AS 'description'
		FROM [dbo].[vm_template_disk] [vm_template_disk]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVmTemplateDisk')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVmTemplateDisk] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVmTemplateDisk]
    @creation_date datetime,
	@description nvarchar(max) = NULL,
	@it_guid uniqueidentifier,
	@vtim_it_guid uniqueidentifier,
	@size bigint,
	@os nvarchar(40),
	@os_version nvarchar(40),
	@bootable bit = NULL,
	@vmt_guid uniqueidentifier,
    @internal_drive_mapping varchar(50)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[image_templates] ([creation_date], [description], [it_guid], [size], [os], [os_version], [bootable])
	VALUES (@creation_date, @description, @it_guid, @size, @os, @os_version, @bootable);
    INSERT INTO [dbo].[vm_template_image_map] ([it_guid], [vmt_guid], [internal_drive_mapping])
	VALUES (@vtim_it_guid, @vmt_guid, @internal_drive_mapping);
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmTemplateDisk')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmTemplateDisk] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmTemplateDisk]
    @creation_date datetime,
	@description nvarchar(max) = NULL,
	@it_guid uniqueidentifier,
	@vtim_it_guid uniqueidentifier,
	@size bigint,
	@os nvarchar(40),
	@os_version nvarchar(40),
	@bootable bit = NULL,
	@vmt_guid uniqueidentifier,
    @internal_drive_mapping varchar(50)
AS
BEGIN

	--The [dbo].[image_templates] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[image_templates] 
	SET [creation_date] = @creation_date, [description] = @description, [size] = @size, [os] = @os, [os_version] = @os_version, [bootable] = @bootable
	WHERE [it_guid]=@it_guid;
	
	UPDATE [dbo].[vm_template_image_map]
	SET [internal_drive_mapping] = @internal_drive_mapping
	WHERE [it_guid]=@vtim_it_guid AND [vmt_guid] = @vmt_guid;
	
	
	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO
