using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.common;
using org.ovirt.engine.ui.uicompat;
using VdcCommon;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.Collections;
using VdcCommon.VdcQueries;
using System.Collections.Specialized;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class UserEventNotifierListModel : SearchableListModel
	{
		#region Commands

		public UICommand ManageEventsCommand { get; private set; }

		#endregion

		#region Properties

		public new DbUser Entity
		{
			get { return (DbUser)base.Entity; }
			set { base.Entity = value; }
		}

		private Model window;
		public Model Window
		{
			get { return window; }
			set
			{
				if (window != value)
				{
					window = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Window"));
				}
			}
		}

		#endregion


		public UserEventNotifierListModel()
		{
			Title = "Event Notifier";

			ManageEventsCommand = new UICommand("ManageEvents", this);
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				base.Search();
			}
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			base.SyncSearch(VdcQueryType.GetEventSubscribersBySubscriberIdGrouped,
					new GetEventSubscribersBySubscriberIdParameters(Entity.user_id));
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			AsyncResult = Frontend.RegisterQuery(VdcQueryType.GetEventSubscribersBySubscriberIdGrouped, new GetEventSubscribersBySubscriberIdParameters(Entity.user_id));
			Items = AsyncResult.Data;
		}

		public void ManageEvents()
		{
			EventNotificationModel model = new EventNotificationModel();
			model.Title = "Add Event Notification";
			model.HashName = "add_event_notification";

			List<EventNotificationEntity> eventTypes = DataProvider.GetEventNotificationTypeList();
			IDictionary<EventNotificationEntity, HashSet<AuditLogType>> availableEvents = DataProvider.GetAvailableNotificationEvents();

			//var tags = DataProvider.GetVisibleTagsList();
			//tags.Insert(0, new tags("", null, null, -1, "none"));

			Translator eventNotificationEntityTranslator = EnumTranslator.Create<EventNotificationEntity>();
			Translator auditLogTypeTranslator = EnumTranslator.Create<AuditLogType>();

			List<SelectionTreeNodeModel> list = new List<SelectionTreeNodeModel>();

			List<event_subscriber> items = Items == null ? new List<event_subscriber>() : Linq.Cast<event_subscriber>(Items);
			foreach (EventNotificationEntity eventType in eventTypes)
			{
				SelectionTreeNodeModel stnm = new SelectionTreeNodeModel();
				stnm.Title = eventType.ToString();
				stnm.Description = eventNotificationEntityTranslator.ContainsKey(eventType) ? eventNotificationEntityTranslator[eventType] : eventType.ToString();
				list.Add(stnm);

				foreach (AuditLogType logtype in availableEvents[eventType])
				{
					SelectionTreeNodeModel eventGrp = new SelectionTreeNodeModel();

					eventGrp.Title = logtype.ToString();
					eventGrp.Description = auditLogTypeTranslator.ContainsKey(logtype) ? auditLogTypeTranslator[logtype] : logtype.ToString();
					eventGrp.Parent = list[list.Count - 1];
					eventGrp.IsSelectedNotificationPrevent = true;
					eventGrp.IsSelectedNullable = false;
					foreach (event_subscriber es in items)
					{
						if (es.event_up_name.Equals(logtype.ToString()))
						{
							eventGrp.IsSelectedNullable = true;
							break;
						}
					}
					//					eventGrp.IsSelected = items.Count(a => a.event_up_name.Equals(logtype.ToString())) > 0 ? true : false;

					list[list.Count - 1].Children.Add(eventGrp);
					eventGrp.IsSelectedNotificationPrevent = false;
				}
				if (list[list.Count - 1].Children.Count > 0) { list[list.Count - 1].Children[0].UpdateParentSelection(); }
			}

			model.EventGroupModels = list;
			//AddModel.Tags = tags;
			//AddModel.Tag = tags.FirstOrDefault();
			if (!string.IsNullOrEmpty(Entity.email))
			{
				model.Email.Entity = Entity.email;
			}
			else if (items.Count > 0)
			{
				model.Email.Entity = items[0].method_address;
			}

			model.OldEmail = (string)model.Email.Entity;

			Window = model;

			model.Commands.Add(
				new UICommand("OnSave", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		public void OnSave()
		{
			EventNotificationModel model = (EventNotificationModel)Window;

			if (!model.Validate())
			{
				return;
			}

			List<VdcActionParametersBase> toAddList = new List<VdcActionParametersBase>();
			List<VdcActionParametersBase> toRemoveList = new List<VdcActionParametersBase>();

			// var selected = model.EventGroupModels.SelectMany(a => a.Children).Where(a => a.IsSelected == true);
			List<SelectionTreeNodeModel> selected = new List<SelectionTreeNodeModel>();
			foreach (SelectionTreeNodeModel node in model.EventGroupModels)
			{
				foreach (SelectionTreeNodeModel child in node.Children)
				{
					if (child.IsSelectedNullable != null && child.IsSelectedNullable == true)
					{
						selected.Add(child);
					}
				}
			}

			List<event_subscriber> existing = Items != null ? Linq.Cast<event_subscriber>(Items) : new List<event_subscriber>();
			List<SelectionTreeNodeModel> added = new List<SelectionTreeNodeModel>();
			List<event_subscriber> removed = new List<event_subscriber>();

			// check what has been added:
			foreach (SelectionTreeNodeModel selectedEvent in selected)
			{
				bool selectedInExisting = false;
				foreach (event_subscriber existingEvent in existing)
				{
					if (selectedEvent.Title.Equals(existingEvent.event_up_name))
					{
						selectedInExisting = true;
						break;
					}
				}

				if (!selectedInExisting)
				{
					added.Add(selectedEvent);
				}
			}

			// check what has been deleted:
			foreach (event_subscriber existingEvent in existing)
			{
				bool existingInSelected = false;
				foreach (SelectionTreeNodeModel selectedEvent in selected)
				{
					if (selectedEvent.Title.Equals(existingEvent.event_up_name))
					{
						existingInSelected = true;
						break;
					}
				}

				if (!existingInSelected)
				{
					removed.Add(existingEvent);
				}
			}
			if (!String.IsNullOrEmpty(model.OldEmail) && !model.OldEmail.Equals((string)model.Email.Entity))
			{
				foreach (event_subscriber a in existing)
				{
					toRemoveList.Add(new EventSubscriptionParametesBase(new event_subscriber(a.event_up_name, (int)EventNotificationMethods.EMAIL, a.method_address, a.subscriber_id, String.Empty), string.Empty));
				}
				foreach (SelectionTreeNodeModel a in selected)
				{
					toAddList.Add(new EventSubscriptionParametesBase(new event_subscriber(a.Title, (int)EventNotificationMethods.EMAIL, (string)model.Email.Entity, Entity.user_id, String.Empty), string.Empty));
				}
			}
			else
			{
				//selected.Each(a => toAddList.Add(new EventSubscriptionParametesBase(new event_subscriber(a.Title, (int)EventNotificationMethods.EMAIL, model.Email.ValueAs<string>(), user.user_id, String.Empty), string.Empty)));
				foreach (SelectionTreeNodeModel a in added)
				{
					toAddList.Add(new EventSubscriptionParametesBase(new event_subscriber(a.Title, (int)EventNotificationMethods.EMAIL, (string)model.Email.Entity, Entity.user_id, String.Empty), string.Empty));
				}

				//existing.Each(a => toRemoveList.Add(new EventSubscriptionParametesBase(new event_subscriber(a.event_up_name, (int)EventNotificationMethods.EMAIL, a.method_address, a.subscriber_id, String.Empty), string.Empty)));
				foreach (event_subscriber a in removed)
				{
					toRemoveList.Add(new EventSubscriptionParametesBase(new event_subscriber(a.event_up_name, (int)EventNotificationMethods.EMAIL, a.method_address, a.subscriber_id, String.Empty), string.Empty));
				}
			}

			if (toRemoveList.Count > 0)
			{
				foreach (VdcActionParametersBase param in toRemoveList)
				{
					Frontend.RunAction(VdcActionType.RemoveEventSubscription, param);
				}
			}

			if (toAddList.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.AddEventSubscription, toAddList);
			}
			Cancel();
		}

		public void Cancel()
		{
			Window = null;
		}

		protected override void ItemsChanged()
		{
			base.ItemsChanged();
			UpdateActionAvailability();
		}

		private void UpdateActionAvailability()
		{
			if (Entity == null || Entity.IsGroup == true)
			{
				ManageEventsCommand.IsExecutionAllowed = false;
			}
			else
			{
				ManageEventsCommand.IsExecutionAllowed = true;
			}
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == ManageEventsCommand)
			{
				ManageEvents();
			}
			if (command.Name == "OnSave")
			{
				OnSave();
			}
			if (command.Name == "Cancel")
			{
				Cancel();
			}
		}
	}
}
