using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.common;
using org.ovirt.engine.ui.uicommon.validation;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class EventNotificationModel : Model
	{
		#region Commands

		public UICommand ExpandAllCommand { get; private set; }
		public UICommand CollapseAllCommand { get; private set; }

		#endregion Commands
		#region Properties

		public bool IsNew { get; set; }

		public EntityModel Email { get; private set; }
		public string OldEmail { get; set; }

		private List<SelectionTreeNodeModel> eventGroupModels;
		public List<SelectionTreeNodeModel> EventGroupModels
		{
			get { return eventGroupModels; }
			set
			{
                if ((eventGroupModels == null && value != null) || (eventGroupModels != null && !eventGroupModels.Equals(value)))
				{
					eventGroupModels = value;
					OnPropertyChanged(new PropertyChangedEventArgs("EventGroupModels"));
				}
			}
		}

		#endregion

		public EventNotificationModel()
		{
			ExpandAllCommand = new UICommand("ExpandAll", this);
			CollapseAllCommand = new UICommand("CollapseAll", this);

			Email = new EntityModel();
		}

		public void ExpandAll()
		{
			//EventGroupModels.Each(a => a.IsExpanded = true);
			foreach (SelectionTreeNodeModel a in EventGroupModels)
			{
				a.IsExpanded = true;
			}
		}

		public void CollapseAll()
		{
			//EventGroupModels.Each(a => a.IsExpanded = false);
			foreach (SelectionTreeNodeModel a in EventGroupModels)
			{
				a.IsExpanded = false;
			}
		}

		internal bool Validate()
		{
			Email.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new EmailValidation() });

			return Email.IsValid;
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == ExpandAllCommand)
			{
				ExpandAll();
			}
			if (command == CollapseAllCommand)
			{
				CollapseAll();
			}
		}

	}

}
