using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Reflection;
using System.Text;
using System.Windows.Input;
using System.Windows;
using System.Windows.Threading;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon
{
	/// <summary>
	/// Represents a command adapted to use in model-viewmodel pattern + binding.
	/// </summary>
	public class UICommand : Model, ICommand
	{
		#region Properties

		private bool isExecutionAllowed;
		/// <summary>
		/// Gets or sets the flag indincating whether this command
		/// is available but can't be executed from some reasons.
		/// </summary>
		public bool IsExecutionAllowed
		{
			get { return isExecutionAllowed; }
			set
			{
				if (isExecutionAllowed != value)
				{
					isExecutionAllowed = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsExecutionAllowed"));

					if (IsExecutionAllowed)
					{
						ExecuteProhibitionReasons.Clear();
					}
				}
			}
		}

		public IList<string> ExecuteProhibitionReasons { get; set; }

		public bool IsDefault { get; set; }
		public bool IsCancel { get; set; }

		public string Name { get; set; }

		#endregion

		private readonly ICommandTarget target;

		public UICommand(string name, ICommandTarget target)
			: this()
		{
			Name = name;
			this.target = target;
		}

		private UICommand()
		{
			ExecuteProhibitionReasons = new ObservableCollection<string>();
			IsExecutionAllowed = true;
		}

		#region ICommand Members

		public bool CanExecute(object parameter)
		{
			return true;
		}

		public event EventHandler CanExecuteChanged = delegate { };

		public void Execute(object parameter)
		{
			if (!IsAvailable || !IsExecutionAllowed)
			{
				return;
			}

			if (target != null)
			{
				target.ExecuteCommand(this);
			}
		}

		#endregion

		public void Execute()
		{
			Execute(null);
		}
	}
}
