using System;
using System.Collections.Generic;
using System.Text;
using VdcCommon.BusinessEntities;
//using VdcCommon.BusinessEntities.DbBroker.AuditLogHandling;

namespace SearchBackend
{
    class AuditLogConditionFieldAutoCompleter : BaseConditionFieldAutoCompleter
    {
        public AuditLogConditionFieldAutoCompleter()
            : base()
        {
            //Building the basic vervs Dict
            mVerbs.Add("TYPE", "TYPE");
            mVerbs.Add("SEVERITY", "SEVERITY");
            mVerbs.Add("MESSAGE", "MESSAGE");
            mVerbs.Add("TIME", "TIME");
			mVerbs.Add("USRNAME", "USRNAME");
            mVerbs.Add("EVENT_HOST", "EVENT_HOST");
            mVerbs.Add("EVENT_VM", "EVENT_VM");
            mVerbs.Add("EVENT_TEMPLATE", "EVENT_TEMPLATE");
            mVerbs.Add("EVENT_STORAGE", "EVENT_STORAGE");
            mVerbs.Add("EVENT_DATACENTER", "EVENT_DATACENTER");
            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("TYPE", typeof(int));
            TypeDictionary.Add("SEVERITY", typeof(AuditLogSeverity));
            TypeDictionary.Add("MESSAGE",typeof(string));
            TypeDictionary.Add("TIME", typeof(DateTime));
			TypeDictionary.Add("USRNAME", typeof(string));
            TypeDictionary.Add("EVENT_HOST", typeof(string));
            TypeDictionary.Add("EVENT_VM", typeof(string));
            TypeDictionary.Add("EVENT_TEMPLATE", typeof(string));
            TypeDictionary.Add("EVENT_STORAGE", typeof(string));
            TypeDictionary.Add("EVENT_DATACENTER", typeof(string));

            //building the ColumnName Dict
            mColumnNameDict.Add("TYPE", "log_type");
            mColumnNameDict.Add("SEVERITY", "severity");
            mColumnNameDict.Add("MESSAGE", "message");
            mColumnNameDict.Add("TIME", "log_time");
			mColumnNameDict.Add("USRNAME", "user_name");
            mColumnNameDict.Add("EVENT_HOST", "vds_name");
            mColumnNameDict.Add("EVENT_VM", "vm_name");
            mColumnNameDict.Add("EVENT_TEMPLATE", "vm_template_name");
            mColumnNameDict.Add("EVENT_STORAGE", "storage_domain_name");
            mColumnNameDict.Add("EVENT_DATACENTER", "storage_pool_name");
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
            IAutoCompleter retval = null;
            switch (fieldName)
            {
                case "SEVERITY":
                    retval = new NumericConditionRelationAutoCompleter();
                    break;
                case "TIME":
                    retval = new TimeConditionRelationAutoCompleter();
                    break;
                case "TYPE":
                case "MESSAGE":
				case "USRNAME":
				case "EVENT_HOST":
                case "EVENT_VM":
                case "EVENT_TEMPLATE":
                case "EVENT_STORAGE":
                case "EVENT_DATACENTER":
					retval = new StringConditionRelationAutoCompleter();
					break;
                default:
                    break;
            }
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "TYPE":
                    //retval = new EnumValueAutoCompleter(typeof(AuditLogType));
                    break;
                case "SEVERITY":
                    retval = new EnumValueAutoCompleter(typeof(AuditLogSeverity));
                    break;
                case "TIME":
                    retval = new DateEnumValueAutoCompleter(typeof(DateEnumForSearch));
                    break;
                default:
                    break;
            }
            return retval;
        }        
    }
}
