package org.ovirt.engine.api.restapi.types;

import java.util.List;

import com.redhat.rhevm.api.common.util.StatusUtils;
import com.redhat.rhevm.api.model.Creation;
import com.redhat.rhevm.api.model.Fault;
import com.redhat.rhevm.api.model.CreationStatus;
import org.ovirt.engine.core.common.businessentities.AsyncTaskStatus;

public class CreationMapper {

    @Mapping(from = List.class, to = Creation.class)
    public static Creation map(List<AsyncTaskStatus> entity, Creation template) {
        Creation model = template != null ? template : new Creation();
        CreationStatus asyncStatus = null;
        for (AsyncTaskStatus task : entity) {
            asyncStatus = AsyncTaskMapper.map(task, asyncStatus);
        }
        model.setStatus(StatusUtils.create(asyncStatus));
        if (model.getStatus().getState().equals(CreationStatus.FAILED.value())) {
            model.setFault(new Fault());
            for (AsyncTaskStatus task : entity) {
                if (task.getException() != null) {
                    model.getFault().setDetail(task.getException().toString());
                    break;
                }
            }
        }
        return model;
    }
}
