@echo off

if "%1%" == "-h" goto Syntax
if "%1%" == "--help" goto Syntax


SET sqlServer=%1%
if "%1%" == "" set sqlServer=.\sqlexpress

SET dbname=%2%
if "%2%" == "" set dbname=rhevm 

for %%v in (%0) do set MyPath=%%~dpv
pushd "%MyPath%"

SET user=%3%
if "%3%" == "" set user=sa

SET pass=%4%
if "%4%" == "" set pass=RHEVMadmin2009!

SET debug=%5%
if "%5%" == "" set debug='true'

echo server - %sqlServer%
echo dbname - %dbname%
echo Creating DB ...
sqlcmd -b -S %sqlServer% -U %user% -P %pass% -d Master -i create_vdc_db.sql -v dbname=%dbname%

if %ERRORLEVEL% NEQ 0 goto ERROR

echo Done.

echo create tables ...
sqlcmd -b  -S %sqlServer% -U %user% -P %pass% -d %dbname%  -i create_vdc_tables_1.sql

if %ERRORLEVEL% NEQ 0 goto ERROR
echo Done.

echo create functions ...
sqlcmd -b  -S %sqlServer% -U %user% -P %pass% -d %dbname% -i functions.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
echo Done.

echo create views ...
sqlcmd -b  -S %sqlServer% -U %user% -P %pass% -d %dbname% -i create_views.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
echo Done.

echo creating the Stored Procedures .....
REM -------------------------------------------------------------------------------
REM Force running common_sp before other procedures to avoid warnings and after it
REM to insure that error handling procedure is not overridden by auto generated sql.
REM -------------------------------------------------------------------------------

sqlcmd -b -S %sqlServer% -U %user% -P %pass% -d %dbname% -v debug=%debug% -i common_sp.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
REM USING ERRORLEVEL in the loop rather than %ERRORLEVEL% since %ERRORLEVEL% gives 0 code even if one of the sp scripts fails.
REM The for loop should be one-liner since in cmd, environment variables within a FOR loop 
REM are expanded at the beginning of the loop, so when you use %sqlServer% 
REM (and the value passedto that script is (localhost)\SQLEXPRESS ) the cmd throws an exception.
for %%v in (*_sp.sql) do sqlcmd -b -S %sqlServer% -U %user% -P %pass% -d %dbname% -i %%v  || if ERRORLEVEL 1 goto ERROR
sqlcmd -b -S %sqlServer% -U %user% -P %pass% -d %dbname% -v debug=%debug% -i common_sp.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
echo Done.

echo populating data
sqlcmd -b  -S %sqlServer% -U %user% -P %pass% -d %dbname% -i insert_data.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
sqlcmd -b  -S %sqlServer% -U %user% -P %pass% -d %dbname% -i insert_predefined_roles.sql 
if %ERRORLEVEL% NEQ 0 goto ERROR
echo Done.

popd

goto:EOF

:Syntax
echo create_vdc_db.cmd [server] [dbname] [user] [pass] [debug]
echo     server - the sql server to access (default = .\sqlexpress)
echo     dbname - the database name to access/create (default = rhevm)
echo	 user - the database administrator user name
echo	 pass - the database administrator password
echo	 debug - true/false enables storing of exception data in DB
goto:EOF

:ERROR
exit /b 1
