/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.Collection;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.FirstPassMethodInstrumenter;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ClassInstrumenter
extends ClassAdapter {
    private static final Logger logger = Logger.getLogger(ClassInstrumenter.class);
    private static final String hasBeenInstrumented = "net/sourceforge/cobertura/coveragedata/HasBeenInstrumented";
    private Collection ignoreRegexs;
    private Collection ignoreBranchesRegexs;
    private ProjectData projectData;
    private ClassData classData;
    private String myName;
    private boolean instrument = false;

    public String getClassName() {
        return this.myName;
    }

    public boolean isInstrumented() {
        return this.instrument;
    }

    public ClassInstrumenter(ProjectData projectData, ClassVisitor cv, Collection ignoreRegexs, Collection ignoreBranchesRegexes) {
        super(cv);
        this.projectData = projectData;
        this.ignoreRegexs = ignoreRegexs;
        this.ignoreBranchesRegexs = this.ignoreBranchesRegexs;
    }

    private boolean arrayContains(Object[] array, Object key) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myName = name.replace('/', '.');
        this.classData = this.projectData.getOrCreateClassData(this.myName);
        this.classData.setContainsInstrumentationInfo();
        if ((access & 0x200) != 0 || this.arrayContains(interfaces, hasBeenInstrumented)) {
            super.visit(version, access, name, signature, superName, interfaces);
        } else {
            this.instrument = true;
            String[] newInterfaces = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            newInterfaces[newInterfaces.length - 1] = hasBeenInstrumented;
            super.visit(version, access, name, signature, superName, newInterfaces);
        }
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.classData.setSourceFileName(source);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (!this.instrument) {
            return mv;
        }
        return mv == null ? null : new FirstPassMethodInstrumenter(this.classData, mv, this.myName, access, name, desc, signature, exceptions, this.ignoreRegexs, this.ignoreBranchesRegexs);
    }

    public void visitEnd() {
        if (this.instrument && this.classData.getNumberOfValidLines() == 0) {
            logger.warn((Object)("No line number information found for class " + this.myName + ".  Perhaps you need to compile with debug=true?"));
        }
    }
}

