﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Forms.Integration;
using Control = System.Windows.Forms.Control;

namespace UI.WPFClient
{
	public class ActiveXContainer : DependencyObject
	{
		#region Properties

		public IList<WindowsFormsHost> Items
		{
			get { return (IList<WindowsFormsHost>)GetValue(ItemsProperty); }
			set { SetValue(ItemsProperty, value); }
		}
		public static readonly DependencyProperty ItemsProperty =
			DependencyProperty.Register("Items", typeof(IList<WindowsFormsHost>), typeof(ActiveXContainer), new UIPropertyMetadata(null));

		#endregion

		public ActiveXContainer()
		{
			Items = new ObservableCollection<WindowsFormsHost>();
		}

		public void Add(object item)
		{
			Items.Add(
				new WindowsFormsHost
				{
					Child = (Control)item,
					Width = 0,
					Height = 0
				});
		}

		public void Remove(object item)
		{
			var container = Items.FirstOrDefault(a => a.Child == item);
			if (container != null)
			{
				Items.Remove(container);
				container.Child = null;
				container.Dispose();

				//((System.Windows.Forms.Control)item).Dispose();
			}
		}
	}
}
