using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.validation;

using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class HostBondInterfaceModel : Model
	{
		#region Properties

		public ListModel Bond { get; private set; }
		public EntityModel Address { get; private set; }
		public EntityModel Subnet { get; private set; }
		public EntityModel Gateway { get; private set; }
		public ListModel Network { get; private set; }
		public ListModel BondingOptions { get; private set; }
		public EntityModel CheckConnectivity { get; private set; }

		private NetworkBootProtocol bootProtocol;
		public NetworkBootProtocol BootProtocol
		{
			get
			{
				return bootProtocol;
			}

			set
			{
				if (bootProtocol != value)
				{
					bootProtocol = value;
					BootProtocolChanged();
					OnPropertyChanged(new PropertyChangedEventArgs("BootProtocol"));
				}
			}
		}

		private bool noneBootProtocolAvailable = true;
		public bool NoneBootProtocolAvailable
		{
			get
			{
				return noneBootProtocolAvailable;
			}

			set
			{
				if (noneBootProtocolAvailable != value)
				{
					noneBootProtocolAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NoneBootProtocolAvailable"));
				}
			}
		}

		public bool IsStaticAddress
		{
			get
			{
				return BootProtocol == NetworkBootProtocol.StaticIp;
			}
		}

		private bool commitChanges;
		public bool CommitChanges
		{
			get { return commitChanges; }
			set
			{
				if (commitChanges != value)
				{
					commitChanges = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CommitChanges"));
				}
			}
		}

		#endregion

		public HostBondInterfaceModel()
		{
			Address = new EntityModel();
			Subnet = new EntityModel();
			Gateway = new EntityModel();
			Bond = new ListModel();
			Network = new ListModel();
			BondingOptions = new ListModel();
			KeyValuePair<string, EntityModel> defaultItem;
			List<KeyValuePair<string, EntityModel>> list = DataProvider.GetBondingOptionList(out defaultItem);
			BondingOptions.Items = list;
			BondingOptions.SelectedItem = defaultItem;
			CheckConnectivity = new EntityModel();
			CheckConnectivity.Entity = false;

			Network.SelectedItemChangedEvent.addListener(this);

			// call the Network_ValueChanged method to set all
			// properties according to default value of Network:
			Network_SelectedItemChanged(null);
		}

		void Network_SelectedItemChanged(EventArgs e)
		{
			UpdateCanSpecify();

			// ** TODO: When BootProtocol will be added to 'network', and when
			// ** BootProtocol, Address, Subnet, and Gateway will be added to 
			// ** the Network Add/Edit dialog, the next lines will be uncommented.
			// ** DO NOT DELETE NEXT COMMENTED LINES!
			//var network = (network)Network;
			//BootProtocol = network == null ? null : network.bootProtocol;
			//Address.Value = network == null ? null : network.addr;
			//Subnet.Value = network == null ? null : network.subnet;
			//Gateway.Value = network == null ? null : network.gateway;
		}

		private void BootProtocolChanged()
		{
			UpdateCanSpecify();

			Address.IsValid = true;
			Subnet.IsValid = true;
			Gateway.IsValid = true;
		}

		private void UpdateCanSpecify()
		{
			network network = (network)Network.SelectedItem;
			bool isChangeble = IsStaticAddress && network != null && !network.Id.Equals(Guid.Empty);
			Address.IsChangable = isChangeble;
			Subnet.IsChangable = isChangeble;
			Gateway.IsChangable = isChangeble;
		}

		internal virtual bool Validate()
		{
			Network.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			Bond.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			Address.IsValid = true;
			Subnet.IsValid = true;
			Gateway.IsValid = true;

			if (IsStaticAddress)
			{
				Address.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new IpAddressValidation() });
				Subnet.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new IpAddressValidation() });
				Gateway.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new IpAddressValidation() });
			}

			return Bond.IsValid
				   && Network.IsValid
				   && Address.IsValid
				   && Subnet.IsValid
				   && Gateway.IsValid;
		}
	}
}
