using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.hosts;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.VdcQueries;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.clusters
{
	public class ClusterHostListModel : HostListModel
	{
		#region Properties

		public new VDSGroup Entity
		{
			get { return base.Entity as VDSGroup; }
			set { base.Entity = value; }
		}

		#endregion


		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				SearchString = String.Format("hosts: cluster={0}", Entity.name);
				base.Search();
			}
		}

		protected override void SyncSearch()
		{
			base.SyncSearch(VdcQueryType.Search, new SearchParameters(SearchString, SearchType.VDS));
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "name")
			{
				SearchCommand.Execute();
			}
		}
	}
}
