using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.vms;

namespace org.ovirt.engine.ui.uicommon
{
	public enum ValidateServerCertificateEnum
	{
		// Validate server certificate.
		TRUE,
		// Don't validate server certificate.
		FALSE,
		// Validate server certificate only if we browse in ssl.
		AUTO
	}

	/// <summary>
	/// Provides configuration values for client side.
	/// </summary>
	public class Configurator
	{
		/// <summary>
		/// Gets the value indincating whether the model state should be changed
		/// asynchronous in response on property change or command execution.
		/// </summary>
		public bool IsAsync { get; protected set; }

		/// <summary>
		/// Gets or sets the value specifying what is the desired Spice version.
		/// </summary>
		public Version SpiceVersion { get; protected set; }

		public bool IsAdmin { get; protected set; }

		public int SpiceDefaultUsbPort { get; protected set; }
		public int SpiceDisableUsbListenPort { get; protected set; }
		public bool SpiceAdminConsole { get; protected set; }
		public bool SpiceFullScreen { get; protected set; }
		public ValidateServerCertificateEnum ValidateServerCertificate { get; protected set; }
		public string BackendPort { get; protected set; }
		public string LogLevel { get; protected set; }

		/// <summary>
		/// Specifies the interval fronend calls backend to check for updated results
		/// for registered queries and searches. Values is in milliseconds.
		/// </summary>
		public int PollingTimerInterval { get; protected set; }



		public Configurator()
		{
			SpiceVersion = new Version(4, 4);
			SpiceDefaultUsbPort = 32023;
			SpiceDisableUsbListenPort = 0;
			BackendPort = "8080";
			LogLevel = "INFO";
			PollingTimerInterval = 1000;
		}

		public virtual void Configure(SearchableListModel searchableListModel)
		{
			searchableListModel.IsAsync = IsAsync;
		}

		public virtual void Configure(ISpice spice)
		{
			bool isUsbEnabled = DataProvider.IsUSBEnabledByDefault();
			int usbListenPort = isUsbEnabled ? SpiceDefaultUsbPort : SpiceDisableUsbListenPort;
			spice.UsbListenPort = usbListenPort;

			spice.DesiredVersion = SpiceVersion;
			spice.AdminConsole = SpiceAdminConsole;
			spice.FullScreen = SpiceFullScreen;
		}
	}
}
