package org.ovirt.engine.api.restapi.types;

import com.redhat.rhevm.api.model.Permit;
import com.redhat.rhevm.api.model.PermitType;
import com.redhat.rhevm.api.model.RoleType;

import org.ovirt.engine.core.common.businessentities.ActionGroup;

public class PermitMapperTest extends AbstractInvertibleMappingTest<Permit, ActionGroup, ActionGroup> {

    public PermitMapperTest() {
        super(Permit.class, ActionGroup.class, ActionGroup.class);
    }

    @Override
    protected Permit postPopulate(Permit from) {
        ActionGroup actionGroup = MappingTestHelper.shuffle(ActionGroup.class);
        from.setId(Integer.toString(actionGroup.getId()));
        PermitType permitType = PermitMapper.map(actionGroup, (PermitType)null);
        from.setName(permitType.value());
        from.setAdministrative(permitType.getRole()==RoleType.ADMIN);
        return from;
    }

    @Override
    protected void verify(Permit model, Permit transform) {
        assertNotNull(transform);
        assertTrue(transform.isSetName());
        assertEquals(model.getName(), transform.getName());
        assertTrue(transform.isSetId());
        assertEquals(model.getId(), transform.getId());
        assertTrue(transform.isSetAdministrative());
        assertEquals(model.isAdministrative(), transform.isAdministrative());
    }
}
