package org.ovirt.engine.api.restapi.resource;

import com.redhat.rhevm.api.model.Domain;
import com.redhat.rhevm.api.model.User;
import com.redhat.rhevm.api.resource.DomainUserResource;
import com.redhat.rhevm.api.resource.DomainUsersResource;

public class BackendDomainUsersResource extends AbstractBackendUsersResource implements DomainUsersResource {

    private String directoryId;

    public BackendDomainUsersResource(String id, BackendDomainResource parent) {
        super(id,parent);
        this.directoryId = id;
    }

    @Override
    public User addParents(User user) {
        user.setDomain(new Domain());
        user.getDomain().setId(directoryId);
        return user;
    }

    @Override
    @SingleEntityResource
    public DomainUserResource getDomainUserSubResource(String id) {
        return inject(new BackendDomainUserResource(id, this));
    }
}
