/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class NewLocalVariableMethodAdapter
extends MethodAdapter
implements Opcodes {
    protected int firstStackVariable;
    protected int addedStackWords;

    public NewLocalVariableMethodAdapter(MethodVisitor mv, int access, String desc, int addedStackWords) {
        super(mv);
        Type[] args = Type.getArgumentTypes((String)desc);
        this.firstStackVariable = (8 & access) != 0 ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            this.firstStackVariable += args[i].getSize();
        }
        this.addedStackWords = addedStackWords;
    }

    public void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, var >= this.firstStackVariable ? var + this.addedStackWords : var);
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(var >= this.firstStackVariable ? var + this.addedStackWords : var, increment);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, index >= this.firstStackVariable ? index + this.addedStackWords : index);
    }

    public int getAddedStackWords() {
        return this.addedStackWords;
    }

    public int getFirstStackVariable() {
        return this.firstStackVariable;
    }
}

