# (c) 2017 Red Hat Inc.
#
# This file is part of Ansible
#
# Ansible is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ansible is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <http://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json

try:
    from lxml.etree import parse
except ImportError:
    from xml.etree.ElementTree import parse

from units.modules.utils import AnsibleExitJson, AnsibleFailJson, ModuleTestCase


fixture_path = os.path.join(os.path.dirname(__file__), 'fixtures')
fixture_data = {}


def load_fixture(name, content='xml'):
    path = os.path.join(fixture_path, name)
    if path in fixture_data:
        return fixture_data[path]

    if content == 'str':
        with open(path) as f:
            data = f.read()
        try:
            data = json.load(path)
        except:
            pass
    else:
        try:
            data = parse(path).getroot()
        except:
            pass

    fixture_data[path] = data
    return data


class TestJunosModule(ModuleTestCase):

    def execute_module(self, failed=False, changed=False, commands=None, sort=True, defaults=False, format='text'):

        self.load_fixtures(commands, format, changed=changed)

        if failed:
            result = self.failed()
            self.assertTrue(result['failed'], result)
        else:
            result = self.changed(changed)
            self.assertEqual(result['changed'], changed, result)

        return result

    def failed(self):
        with self.assertRaises(AnsibleFailJson) as exc:
            self.module.main()

        result = exc.exception.args[0]
        self.assertTrue(result['failed'], result)
        return result

    def changed(self, changed=False):
        with self.assertRaises(AnsibleExitJson) as exc:
            self.module.main()

        result = exc.exception.args[0]
        self.assertEqual(result['changed'], changed, result)
        return result

    def load_fixtures(self, commands=None, format=None, changed=None):
        pass
