/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

class HomeHandler
implements RequestHandler {
    private final CapturedBrowsers capturedBrowsers;
    private final HttpServletResponse response;
    private final PrintWriter writer;

    @Inject
    public HomeHandler(CapturedBrowsers capturedBrowsers, HttpServletResponse response, @ResponseWriter PrintWriter writer) {
        this.capturedBrowsers = capturedBrowsers;
        this.response = response;
        this.writer = writer;
    }

    public void handleIt() throws IOException {
        this.response.setContentType("text/html");
        this.writer.write("<html><head><title>JsTestDriver</title>");
        this.writer.write("</head><body>");
        this.writer.write("<a href=\"/capture\">Capture This Browser</a><br/>");
        this.writer.write("<a href=\"/capture?strict\">Capture This Browser in strict mode</a><br/>");
        this.writer.write("<p><strong>Captured Browsers: (");
        this.writer.write(String.valueOf(this.capturedBrowsers.getSlaveBrowsers().size()));
        this.writer.write(")</strong></p>");
        for (SlaveBrowser browser : this.capturedBrowsers.getSlaveBrowsers()) {
            this.writer.write("<div>");
            BrowserInfo info = browser.getBrowserInfo();
            this.writer.write("Id: " + info.getId() + "<br/>");
            this.writer.write("Name: " + info.getName() + "<br/>");
            this.writer.write("Version: " + info.getVersion() + "<br/>");
            this.writer.write("Operating System: " + info.getOs() + "<br/>");
            if (browser.getCommandRunning() != null) {
                this.writer.write("Currently running " + browser.getCommandRunning() + "<br/>");
            } else {
                this.writer.write("Currently waiting...<br/>");
            }
            this.writer.write("<ul style='display:none'>");
            for (FileInfo fileInfo : browser.getFileSet()) {
                this.writer.write("<li>");
                this.writer.write(fileInfo.getDisplayPath());
                this.writer.write("</li>");
            }
            this.writer.write("</ul>");
            this.writer.write("</div>");
            this.writer.flush();
        }
        this.writer.write("</body></html>");
        this.writer.flush();
    }
}

