class ConvertIpamToString < ActiveRecord::Migration
  class FakeSubnet < ActiveRecord::Base
    self.table_name = 'subnets'
  end

  def up
    add_column :subnets, :ipam_tmp, :string, :default => Subnet::IPAM_MODES[:dhcp], :null => false
    FakeSubnet.reset_column_information
    FakeSubnet.all.each do |subnet|
      if subnet.ipam
        subnet.ipam_tmp = Subnet::IPAM_MODES[:dhcp]
      else
        subnet.ipam_tmp = Subnet::IPAM_MODES[:none]
      end
      subnet.save!
    end
    remove_column :subnets, :ipam
    rename_column :subnets, :ipam_tmp, :ipam
  end

  def down
    add_column :subnets, :ipam_tmp, :boolean, :default => true, :null => false
    FakeSubnet.reset_column_information
    FakeSubnet.all.each do |subnet|
      subnet.ipam_tmp = subnet.ipam != Subnet::IPAM_MODES[:none]
      subnet.save!
    end
    remove_column :subnets, :ipam
    rename_column :subnets, :ipam_tmp, :ipam
  end
end
