/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetCacheStrategy;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileCacheHandler
implements RequestHandler {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Gson gson;
    private final Set<FileInfo> currentFiles;
    private final FileSetCacheStrategy strategy;

    @Inject
    public FileCacheHandler(HttpServletRequest request, HttpServletResponse response, Gson gson, Set<FileInfo> currentFiles, FileSetCacheStrategy strategy) {
        this.request = request;
        this.response = response;
        this.gson = gson;
        this.currentFiles = currentFiles;
        this.strategy = strategy;
    }

    @Override
    public void handleIt() throws IOException {
        String fileSetString = this.request.getParameter("fileSet");
        Collection newFiles = (Collection)this.gson.fromJson(fileSetString, new TypeToken<Collection<FileInfo>>(){}.getType());
        this.response.getWriter().write(this.gson.toJson(this.strategy.createExpiredFileSet(newFiles, this.currentFiles)));
        for (FileInfo fileInfo : newFiles) {
            this.currentFiles.remove(fileInfo);
            this.currentFiles.add(fileInfo);
        }
    }
}

