/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.ha.framework.server.ProtocolStackConfigInfo;
import org.jboss.logging.Logger;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolStackUtil {
    private static final Logger log = Logger.getLogger(ProtocolStackUtil.class);
    private static final String PROTOCOL_STACKS = "protocol_stacks";
    private static final String STACK = "stack";
    private static final String NAME = "name";
    private static final String DESCR = "description";
    private static final String CONFIG = "config";

    public static Map<String, ProtocolStackConfigInfo> parse(InputStream input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element configElement = document.getDocumentElement();
        return ProtocolStackUtil.parse(configElement);
    }

    public static Map<String, ProtocolStackConfigInfo> parse(Element root) throws Exception {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        String root_name = root.getNodeName();
        if (!PROTOCOL_STACKS.equals(root_name.trim().toLowerCase())) {
            throw new IOException("Invalid XML configuration: configuration does not start with a 'protocol_stacks' element");
        }
        HashMap<String, ProtocolStackConfigInfo> result = new HashMap<String, ProtocolStackConfigInfo>();
        NodeList tmp_stacks = root.getChildNodes();
        for (int i = 0; i < tmp_stacks.getLength(); ++i) {
            Node node = tmp_stacks.item(i);
            if (node.getNodeType() != 1) continue;
            Element stack = (Element)node;
            String tmp = stack.getNodeName();
            if (!STACK.equals(tmp.trim().toLowerCase())) {
                throw new IOException("Invalid configuration: didn't find a \"stack\" element under \"protocol_stacks\"");
            }
            NamedNodeMap attrs = stack.getAttributes();
            Node name = attrs.getNamedItem(NAME);
            String st_name = name.getNodeValue();
            Node descr = attrs.getNamedItem(DESCR);
            String stack_descr = descr.getNodeValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parsing \"" + st_name + "\" (" + stack_descr + ")"));
            }
            NodeList configs = stack.getChildNodes();
            for (int j = 0; j < configs.getLength(); ++j) {
                Node tmp_config = configs.item(j);
                if (tmp_config.getNodeType() != 1) continue;
                Element cfg = (Element)tmp_config;
                tmp = cfg.getNodeName();
                if (!CONFIG.equals(tmp)) {
                    throw new IOException("Invalid configuration: didn't find a \"config\" element under \"stack\"");
                }
                XmlConfigurator conf = XmlConfigurator.getInstance((Element)cfg);
                ConfiguratorFactory.substituteVariables((ProtocolStackConfigurator)conf);
                result.put(st_name, new ProtocolStackConfigInfo(st_name, stack_descr, (ProtocolStackConfigurator)conf));
            }
        }
        return result;
    }

    public static ProtocolData[] getProtocolData(ProtocolStackConfigurator config) {
        ProtocolData[] result = null;
        try {
            result = config.getProtocolStack();
        }
        catch (UnsupportedOperationException e) {
            String s = config.getProtocolStackString();
            String[] prots = s.split(":");
            result = new ProtocolData[prots.length];
            for (int i = 0; i < prots.length; ++i) {
                String name;
                ProtocolParameter[] params = null;
                int paren = prots[i].indexOf(40);
                String string = name = paren > -1 ? prots[i].substring(0, paren) : prots[1];
                if (paren > -1 && paren < prots[1].length() - 2) {
                    String unsplit = prots[i].substring(paren + 1, prots[i].length() - 1);
                    String[] split = unsplit.split(";");
                    params = new ProtocolParameter[split.length];
                    for (int j = 0; j < split.length; ++j) {
                        String[] keyVal = split[j].split("=");
                        params[j] = new ProtocolParameter(keyVal[0], keyVal[1]);
                    }
                } else {
                    params = new ProtocolParameter[]{};
                }
                result[i] = new ProtocolData(name, null, name, params);
            }
        }
        return result == null ? new ProtocolData[]{} : result;
    }

    private ProtocolStackUtil() {
    }
}

