/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.client.impl.ClientLargeMessageImpl;
import org.hornetq.core.client.impl.ClientLargeMessageInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionReceiveLargeMessage
extends PacketImpl {
    private static final Logger log = Logger.getLogger(SessionReceiveLargeMessage.class);
    private MessageInternal message;
    private long largeMessageSize;
    private long consumerID;
    private int deliveryCount;

    public SessionReceiveLargeMessage() {
        super((byte)76);
        this.message = new ClientLargeMessageImpl();
    }

    public SessionReceiveLargeMessage(long consumerID, MessageInternal message, long largeMessageSize, int deliveryCount) {
        super((byte)76);
        this.consumerID = consumerID;
        this.message = message;
        this.deliveryCount = deliveryCount;
        this.largeMessageSize = largeMessageSize;
    }

    public MessageInternal getLargeMessage() {
        return this.message;
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public long getLargeMessageSize() {
        return this.largeMessageSize;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
        buffer.writeLong(this.largeMessageSize);
        this.message.encodeHeadersAndProperties(buffer);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
        this.largeMessageSize = buffer.readLong();
        this.message.decodeHeadersAndProperties(buffer);
        ((ClientLargeMessageInternal)this.message).setLargeMessageSize(this.largeMessageSize);
    }
}

