/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.zip.ZipEntryContextInfo;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryInfo
implements ZipEntryContextInfo {
    static final Certificate[] MARKER = new Certificate[0];
    private AbstractVirtualFileHandler handler;
    private ZipEntry entry;
    private Certificate[] certificates;
    private Map<String, AbstractVirtualFileHandler> children;

    EntryInfo(AbstractVirtualFileHandler handler, ZipEntry entry) {
        this.handler = handler;
        this.entry = entry;
    }

    @Override
    public void readCertificates() {
        if (this.certificates == null) {
            Certificate[] certs = null;
            if (this.entry instanceof JarEntry) {
                certs = ((JarEntry)JarEntry.class.cast(this.entry)).getCertificates();
            }
            this.certificates = certs != null ? certs : MARKER;
        }
    }

    @Override
    public Certificate[] getCertificates() {
        return this.certificates != MARKER ? this.certificates : null;
    }

    @Override
    public synchronized List<VirtualFileHandler> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return new ArrayList<VirtualFileHandler>(this.children.values());
    }

    @Override
    public synchronized void replaceChild(AbstractVirtualFileHandler original, AbstractVirtualFileHandler replacement) {
        String name;
        if (this.children != null && this.children.containsKey(name = original.getName())) {
            this.children.put(name, replacement);
        }
    }

    @Override
    public synchronized void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    @Override
    public synchronized void add(AbstractVirtualFileHandler child) {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, AbstractVirtualFileHandler>();
        }
        this.children.put(child.getName(), child);
    }

    @Override
    public String getName() {
        return this.entry != null ? this.entry.getName() : this.handler.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.entry != null && this.entry.isDirectory();
    }

    @Override
    public boolean requiresUpdate() {
        return this.certificates == null;
    }

    @Override
    public ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public void setEntry(ZipEntry entry) {
        this.entry = entry;
    }

    @Override
    public long getTime() {
        return this.entry != null ? this.entry.getTime() : 0L;
    }

    @Override
    public long getSize() {
        return this.entry != null ? this.entry.getSize() : 0L;
    }

    @Override
    public AbstractVirtualFileHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(AbstractVirtualFileHandler handler) {
        this.handler = handler;
    }
}

