/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.io.IOException;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.mcmp.MCMPURLEncoder;

public class MCMPJBURLEncoder
implements MCMPURLEncoder {
    private static StringManager sm = StringManager.getManager((String)Constants.Package);
    private final CharChunk body;
    private final UEncoder encoder = new UEncoder();

    public MCMPJBURLEncoder() {
        try {
            this.body = this.encoder.encodeURL("", 0, 0);
            this.body.recycle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void encodeParameter(String key, String value, boolean hasNext) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException(sm.getString("modcluster.error.nullAttribute", (Object)key));
        }
        this.encoder.encodeURL(key, 0, key.length()).append('=');
        CharChunk body = this.encoder.encodeURL(value, 0, value.length());
        if (hasNext) {
            body.append('&');
        }
    }

    public int getLength() {
        return this.body.getLength();
    }

    public char[] getBuffer() {
        return this.body.getBuffer();
    }
}

