/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.hornetq.utils.SensitiveDataCodec;

public class DefaultSensitiveStringCodec
implements SensitiveDataCodec<String> {
    private byte[] KEY_BYTES = "clusterpassword".getBytes();

    @Override
    public String decode(Object secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec key = new SecretKeySpec(this.KEY_BYTES, "Blowfish");
        BigInteger n = new BigInteger((String)secret, 16);
        byte[] encoding = n.toByteArray();
        if (encoding.length % 8 != 0) {
            int length = encoding.length;
            int newLength = (length / 8 + 1) * 8;
            int pad = newLength - length;
            byte[] old = encoding;
            encoding = new byte[newLength];
            for (int i = old.length - 1; i >= 0; --i) {
                encoding[i + pad] = old[i];
            }
        }
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(2, key);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode);
    }

    public Object encode(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec key = new SecretKeySpec(this.KEY_BYTES, "Blowfish");
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(1, key);
        byte[] encoding = cipher.doFinal(secret.getBytes());
        BigInteger n = new BigInteger(encoding);
        return n.toString(16);
    }

    public static void main(String[] args) throws Exception {
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        Object encode = codec.encode(args[0]);
        System.out.println("Encoded password: " + encode);
    }

    @Override
    public void init(Map<String, String> params) {
        String key = params.get("key");
        if (key != null) {
            this.updateKey(key);
        }
    }

    private void updateKey(String key) {
        this.KEY_BYTES = key.getBytes();
    }
}

