/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatelessSessionContainer;

public class StatelessSessionEnterpriseContext
extends EnterpriseContext {
    EJBObject ejbObject;
    EJBLocalObject ejbLocalObject;
    MessageContext soapMessageContext;
    SessionContext ctx = new SessionContextImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatelessSessionEnterpriseContext(Object instance, Container con) throws Exception {
        super(instance, con);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_SET_SESSION_CONTEXT);
            ((SessionBean)instance).setSessionContext(this.ctx);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
            Method ejbCreate = instance.getClass().getMethod("ejbCreate", new Class[0]);
            ejbCreate.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            if (ex instanceof EJBException) {
                throw (Exception)ex;
            }
            if (ex instanceof RuntimeException) {
                throw new EJBException((Exception)ex);
            }
            if (ex instanceof Exception) {
                throw (Exception)ex;
            }
            throw (Error)ex;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    public void setEJBObject(EJBObject eo) {
        this.ejbObject = eo;
    }

    public EJBObject getEJBObject() {
        return this.ejbObject;
    }

    public void setEJBLocalObject(EJBLocalObject eo) {
        this.ejbLocalObject = eo;
    }

    public EJBLocalObject getEJBLocalObject() {
        return this.ejbLocalObject;
    }

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    public void setMessageContext(MessageContext msgContext) {
        this.soapMessageContext = msgContext;
    }

    public void discard() throws RemoteException {
        ((SessionBean)this.instance).ejbRemove();
    }

    public EJBContext getEJBContext() {
        return this.ctx;
    }

    public class TimerServiceWrapper
    implements TimerService {
        private EnterpriseContext.EJBContextImpl context;
        private TimerService timerService;

        public TimerServiceWrapper(EnterpriseContext.EJBContextImpl ctx, TimerService timerService) {
            this.context = ctx;
            this.timerService = timerService;
        }

        public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(duration, info);
        }

        public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(initialDuration, intervalDuration, info);
        }

        public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(expiration, info);
        }

        public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(initialExpiration, intervalDuration, info);
        }

        public Collection getTimers() throws IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.getTimers");
            return this.timerService.getTimers();
        }

        private void assertAllowedIn(String timerMethod) {
            AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
        }
    }

    protected class SessionContextImpl
    extends EnterpriseContext.EJBContextImpl
    implements SessionContext {
        protected SessionContextImpl() {
        }

        public EJBHome getEJBHome() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return super.getEJBHome();
        }

        public EJBLocalHome getEJBLocalHome() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBLocalHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return super.getEJBLocalHome();
        }

        public EJBObject getEJBObject() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            if (((StatelessSessionContainer)StatelessSessionEnterpriseContext.this.con).getProxyFactory() == null) {
                throw new IllegalStateException("No remote interface defined.");
            }
            if (StatelessSessionEnterpriseContext.this.ejbObject == null) {
                EJBProxyFactory proxyFactory = StatelessSessionEnterpriseContext.this.con.getProxyFactory();
                if (proxyFactory == null) {
                    String defaultInvokerName = StatelessSessionEnterpriseContext.this.con.getBeanMetaData().getContainerConfiguration().getDefaultInvokerName();
                    proxyFactory = StatelessSessionEnterpriseContext.this.con.lookupProxyFactory(defaultInvokerName);
                }
                StatelessSessionEnterpriseContext.this.ejbObject = (EJBObject)proxyFactory.getStatelessSessionEJBObject();
            }
            return StatelessSessionEnterpriseContext.this.ejbObject;
        }

        public Object getBusinessObject(Class businessInterface) throws IllegalStateException {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public Class getInvokedBusinessInterface() throws IllegalStateException {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public EJBLocalObject getEJBLocalObject() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBLocalObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            if (StatelessSessionEnterpriseContext.this.con.getLocalHomeClass() == null) {
                throw new IllegalStateException("No local interface for bean.");
            }
            if (StatelessSessionEnterpriseContext.this.ejbLocalObject == null) {
                StatelessSessionEnterpriseContext.this.ejbLocalObject = ((StatelessSessionContainer)StatelessSessionEnterpriseContext.this.con).getLocalProxyFactory().getStatelessSessionEJBLocalObject();
            }
            return StatelessSessionEnterpriseContext.this.ejbLocalObject;
        }

        public TimerService getTimerService() throws IllegalStateException {
            AllowedOperationsAssociation.assertAllowedIn("getTimerService", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return new TimerServiceWrapper(this, super.getTimerService());
        }

        public Principal getCallerPrincipal() {
            AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return super.getCallerPrincipal();
        }

        public boolean getRollbackOnly() {
            AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return super.getRollbackOnly();
        }

        public void setRollbackOnly() {
            AllowedOperationsAssociation.assertAllowedIn("setRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            super.setRollbackOnly();
        }

        public boolean isCallerInRole(String id) {
            AllowedOperationsAssociation.assertAllowedIn("isCallerInRole", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return super.isCallerInRole(id);
        }

        public UserTransaction getUserTransaction() {
            AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            final UserTransaction ut = super.getUserTransaction();
            return new UserTransaction(){

                public void begin() throws NotSupportedException, SystemException {
                    SessionContextImpl.this.checkUserTransactionMethods();
                    ut.begin();
                }

                public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
                    SessionContextImpl.this.checkUserTransactionMethods();
                    ut.commit();
                }

                public void rollback() throws IllegalStateException, SecurityException, SystemException {
                    SessionContextImpl.this.checkUserTransactionMethods();
                    ut.rollback();
                }

                public void setRollbackOnly() throws IllegalStateException, SystemException {
                    SessionContextImpl.this.checkUserTransactionMethods();
                    ut.setRollbackOnly();
                }

                public int getStatus() throws SystemException {
                    SessionContextImpl.this.checkUserTransactionMethods();
                    return ut.getStatus();
                }

                public void setTransactionTimeout(int seconds) throws SystemException {
                    SessionContextImpl.this.checkUserTransactionMethods();
                    ut.setTransactionTimeout(seconds);
                }
            };
        }

        private void checkUserTransactionMethods() {
            AllowedOperationsAssociation.assertAllowedIn("UserTransaction methods", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            AllowedOperationsAssociation.assertAllowedIn("getMessageContext", AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
            return StatelessSessionEnterpriseContext.this.soapMessageContext;
        }
    }
}

