/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderHelper {
    private ProviderHelper() {
    }

    public static String readString(InputStream in) throws IOException {
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 1024)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public static String readString(InputStream in, MediaType mediaType) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream builder = new ByteArrayOutputStream();
        int wasRead = 0;
        do {
            if ((wasRead = in.read(buffer, 0, 1024)) <= 0) continue;
            builder.write(buffer, 0, wasRead);
        } while (wasRead > -1);
        byte[] bytes = builder.toByteArray();
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes, "UTF-8");
    }

    public static List<MediaType> getAvailableMediaTypes(String[] mediaTypes) {
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String mediaType : mediaTypes) {
            types.add(MediaType.valueOf((String)mediaType));
        }
        return types;
    }

    public static List<Variant> getAvailableVariants(String[] mediaTypes) {
        return ProviderHelper.getAvailableVariants(ProviderHelper.getAvailableMediaTypes(mediaTypes));
    }

    public static List<Variant> getAvailableVariants(List<MediaType> mediaTypes) {
        Variant.VariantListBuilder builder = Variant.VariantListBuilder.newInstance();
        MediaType[] types = mediaTypes.toArray(new MediaType[mediaTypes.size()]);
        builder.mediaTypes(types);
        return builder.build();
    }

    public static void writeTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[2048];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }
}

