/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import org.jboss.logging.Logger;
import org.jboss.virtual.plugins.context.zip.ZipEntryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ZipWrapper {
    protected static final Logger log = Logger.getLogger(ZipWrapper.class);
    protected long lastModified;
    private long lastChecked;
    private long lastUsed;
    private int refCount = 0;

    ZipWrapper() {
    }

    boolean hasBeenModified() {
        long now = System.currentTimeMillis();
        if (now - this.lastChecked < 1000L) {
            return false;
        }
        this.lastChecked = now;
        long lm = this.getLastModified();
        if (lm != this.lastModified) {
            this.lastModified = lm;
            return true;
        }
        return false;
    }

    long getLastUsed() {
        return this.lastUsed;
    }

    int getReferenceCount() {
        return this.refCount;
    }

    void incrementRef() {
        ++this.refCount;
        this.lastUsed = System.currentTimeMillis();
    }

    synchronized void release() {
        --this.refCount;
        if (this.refCount <= 0) {
            this.lastUsed = System.currentTimeMillis();
        }
    }

    abstract void acquire() throws IOException;

    abstract long getLastModified();

    abstract String getName();

    abstract boolean exists();

    abstract long getSize();

    abstract Enumeration<? extends ZipEntry> entries() throws IOException;

    abstract InputStream openStream(ZipEntryInfo var1) throws IOException;

    abstract InputStream getRootAsStream() throws FileNotFoundException;

    abstract void close();

    abstract boolean delete(int var1) throws IOException;

    protected InputStream recomposeZipAsInputStream(String path) throws FileNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.recomposeZip(baos, path);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            FileNotFoundException e = new FileNotFoundException("Failed to recompose inflated nested archive " + this.getName());
            e.initCause(ex);
            throw e;
        }
    }

    protected void recomposeZip(OutputStream os, String path) throws IOException {
    }
}

