/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.security.exception.FailedAuthenticationException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.metadata.wsse.Authorize;
import org.jboss.ws.metadata.wsse.Role;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeOperation {
    private static final Logger log = Logger.getLogger(AuthorizeOperation.class);
    private Authorize authorize;
    private AuthenticationManager am;
    private RealmMapping rm;
    private SecurityAdaptorFactory secAdapterfactory;

    public AuthorizeOperation(Authorize authorize) {
        this.authorize = authorize;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup("java:comp/env/security/securityMgr");
            this.am = (AuthenticationManager)obj;
            this.rm = (RealmMapping)this.am;
        }
        catch (NamingException ne) {
            throw new WSException("Unable to lookup AuthenticationManager", ne);
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.secAdapterfactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
    }

    public void process() throws WSSecurityException {
        Subject subject;
        Object credential;
        SecurityAdaptor securityAdaptor;
        Principal principal;
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)("About to check authorization, using security domain '" + this.am.getSecurityDomain() + "'"));
        }
        if (!this.am.isValid(principal = (securityAdaptor = this.secAdapterfactory.newSecurityAdapter()).getPrincipal(), credential = securityAdaptor.getCredential(), subject = new Subject())) {
            String msg = "Authentication failed, principal=" + principal;
            log.error((Object)msg);
            SecurityException e = new SecurityException(msg);
            throw new FailedAuthenticationException(e);
        }
        securityAdaptor.pushSubjectContext(subject, principal, credential);
        if (TRACE) {
            log.trace((Object)("Authenticated, principal=" + principal));
        }
        if (this.authorize.isUnchecked()) {
            if (TRACE) {
                log.trace((Object)"authorize.isUnchecked()==true skipping roles check.");
            }
            return;
        }
        Set<Principal> expectedRoles = this.expectedRoles();
        if (TRACE) {
            log.trace((Object)("expectedRoles=" + expectedRoles));
        }
        if (!this.rm.doesUserHaveRole(principal, expectedRoles)) {
            Set userRoles = this.rm.getUserRoles(principal);
            String msg = "Insufficient method permissions, principal=" + principal + ", requiredRoles=" + expectedRoles + ", principalRoles=" + userRoles;
            log.error((Object)msg);
            SecurityException e = new SecurityException(msg);
            throw new FailedAuthenticationException(e);
        }
        if (TRACE) {
            log.trace((Object)("Roles check complete, principal=" + principal + ", requiredRoles=" + expectedRoles));
        }
    }

    private Set<Principal> expectedRoles() {
        List<Role> roles = this.authorize.getRoles();
        int rolesCount = roles != null ? roles.size() : 0;
        HashSet<Principal> expectedRoles = new HashSet<Principal>(rolesCount);
        if (roles != null) {
            for (Role current : roles) {
                expectedRoles.add((Principal)new SimplePrincipal(current.getName()));
            }
        }
        return expectedRoles;
    }
}

