/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.buf.UEncoder;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.mcmp.MCMPURLEncoder;

public class MCMPTCURLEncoder
implements MCMPURLEncoder {
    private static final Method urlEncodeMethod;
    private static final StringManager sm;
    private final CharArrayWriter writer;
    private final UEncoder encoder = new UEncoder();

    public MCMPTCURLEncoder() {
        this.writer = new CharArrayWriter();
    }

    public void encodeParameter(String key, String value, boolean hasNext) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException(sm.getString("modcluster.error.nullAttribute", (Object)key));
        }
        try {
            urlEncodeMethod.invoke((Object)this.encoder, this.writer, key);
        }
        catch (Exception e) {
            this.writer.write(key);
        }
        this.writer.write(61);
        try {
            urlEncodeMethod.invoke((Object)this.encoder, this.writer, value);
        }
        catch (Exception e) {
            this.writer.write(value);
        }
        if (hasNext) {
            this.writer.write(38);
        }
    }

    public int getLength() {
        return this.writer.size();
    }

    public char[] getBuffer() {
        return this.writer.toCharArray();
    }

    static {
        try {
            urlEncodeMethod = UEncoder.class.getMethod("urlEncode", Writer.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        sm = StringManager.getManager((String)Constants.Package);
    }
}

