/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.PostOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ExpressionMappingVisitor
extends LanguageVisitor {
    private Map symbolMap;

    public ExpressionMappingVisitor(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public void visit(Select obj) {
        for (int i = 0; i < obj.getSymbols().size(); ++i) {
            SelectSymbol symbol = obj.getSymbol(i);
            if (!(symbol instanceof Expression)) continue;
            Expression expression = (Expression)symbol;
            boolean needsAlias = !(expression instanceof ExpressionSymbol);
            Expression replacement = this.replaceExpression(expression);
            if (!(replacement instanceof SingleElementSymbol)) {
                String name = ((SingleElementSymbol)expression).getShortName();
                symbol = new ExpressionSymbol(name, replacement);
                if (needsAlias) {
                    symbol = new AliasSymbol(name, (SingleElementSymbol)symbol);
                }
            } else {
                symbol = (SelectSymbol)replacement;
            }
            obj.getSymbols().set(i, symbol);
        }
    }

    public void visit(AliasSymbol obj) {
        Expression replacement = this.replaceExpression((Expression)obj.getSymbol());
        if (replacement instanceof SingleElementSymbol) {
            obj.setSymbol((SingleElementSymbol)replacement);
        } else {
            obj.setSymbol((SingleElementSymbol)new ExpressionSymbol(obj.getName(), replacement));
        }
    }

    public void visit(ExpressionSymbol expr) {
        expr.setExpression(this.replaceExpression(expr.getExpression()));
    }

    public void visit(BetweenCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        obj.setLowerExpression(this.replaceExpression(obj.getLowerExpression()));
        obj.setUpperExpression(this.replaceExpression(obj.getUpperExpression()));
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.replaceExpression(obj.getWhenExpression(i)));
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
        }
    }

    public void visit(CompareCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    public void visit(Function obj) {
        Expression[] args = obj.getArgs();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.replaceExpression(args[i]);
            }
        }
    }

    public void visit(IsNullCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public void visit(MatchCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
        }
    }

    public void visit(SetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        ArrayList<Expression> newValues = new ArrayList<Expression>(obj.getValues().size());
        Iterator valueIter = obj.getValues().iterator();
        while (valueIter.hasNext()) {
            newValues.add(this.replaceExpression((Expression)valueIter.next()));
        }
        obj.setValues(newValues);
    }

    public void visit(DependentSetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public void visit(SubqueryCompareCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
    }

    public void visit(SubquerySetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public Expression replaceExpression(Expression element) {
        Expression mapped = (Expression)this.symbolMap.get(element);
        if (mapped != null) {
            return mapped;
        }
        return element;
    }

    public void visit(StoredProcedure obj) {
        Iterator paramIter = obj.getParameters().iterator();
        while (paramIter.hasNext()) {
            SPParameter param = (SPParameter)paramIter.next();
            Expression expr = param.getExpression();
            param.setExpression(this.replaceExpression(expr));
        }
    }

    public void visit(AggregateSymbol obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public void visit(GroupBy obj) {
        for (int i = 0; i < obj.getCount(); ++i) {
            obj.getSymbols().set(i, this.replaceExpression(obj.getSymbol(i)));
        }
    }

    public static void mapExpressions(LanguageObject obj, Map exprMap) {
        ExpressionMappingVisitor.mapExpressions(obj, exprMap, false);
    }

    public static void mapExpressions(LanguageObject obj, Map exprMap, boolean usePreOrder) {
        if (obj == null || exprMap == null || exprMap.isEmpty()) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(exprMap);
        if (usePreOrder) {
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        } else {
            PostOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        }
    }

    protected void setVariableValues(Map variableValues) {
        this.symbolMap = variableValues;
    }

    protected Map getVariableValues() {
        return this.symbolMap;
    }

    public void visit(AssignmentStatement obj) {
        if (obj.hasExpression()) {
            obj.setExpression(this.replaceExpression(obj.getExpression()));
        }
    }

    public void visit(Insert obj) {
        for (int i = 0; i < obj.getValues().size(); ++i) {
            obj.getValues().set(i, this.replaceExpression((Expression)obj.getValues().get(i)));
        }
    }

    public void visit(DynamicCommand obj) {
        if (obj.getUsing() != null && !obj.getUsing().isEmpty()) {
            Iterator i = obj.getUsing().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                entry.setValue(this.replaceExpression((Expression)entry.getValue()));
            }
        }
        obj.setSql(this.replaceExpression(obj.getSql()));
    }
}

