/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionForm;
import com.metamatrix.query.function.FunctionMetadataSource;
import com.metamatrix.query.function.metadata.FunctionMethod;
import com.metamatrix.query.function.metadata.FunctionParameter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FunctionTree {
    private static final Integer DESCRIPTOR_KEY = new Integer(-1);
    private Map metadata = new HashMap();
    private Map functionsByName = new HashMap();
    private Map treeRoot = new HashMap();
    static /* synthetic */ Class class$com$metamatrix$query$util$CommandContext;
    static /* synthetic */ Class class$java$lang$Object;

    FunctionTree(FunctionMetadataSource source) {
        this.addSource(source);
    }

    FunctionTree(Collection sources) {
        this.addSources(sources);
    }

    private void addSources(Collection sources) {
        if (sources == null) {
            return;
        }
        Iterator sourceIter = sources.iterator();
        while (sourceIter.hasNext()) {
            Object sourceObj = sourceIter.next();
            if (sourceObj instanceof FunctionMetadataSource) {
                this.addSource((FunctionMetadataSource)sourceObj);
                continue;
            }
            Assertion.failed((String)QueryPlugin.Util.getString("ERR.015.001.0044", (Object)sourceObj.getClass().getName()));
        }
    }

    private void addSource(FunctionMetadataSource source) {
        if (source == null) {
            return;
        }
        Collection functions = source.getFunctionMethods();
        if (functions != null) {
            Iterator functionIter = functions.iterator();
            while (functionIter.hasNext()) {
                FunctionMethod method;
                Object functionObj = functionIter.next();
                if (!(functionObj instanceof FunctionMethod)) {
                    Assertion.failed((String)QueryPlugin.Util.getString("ERR.015.001.0045", (Object)functionObj.getClass().getName()));
                }
                if (!this.containsIndistinguishableFunction(method = (FunctionMethod)functionObj)) {
                    this.addMetadata(method);
                    this.addFunction(source, method);
                    continue;
                }
                QueryPlugin.Util.log(2, QueryPlugin.Util.getString("ERR.015.001.0046", new Object[]{method}));
            }
        }
    }

    private boolean containsIndistinguishableFunction(FunctionMethod method) {
        List knownMethods = (List)this.functionsByName.get(method.getName().toUpperCase());
        if (knownMethods == null) {
            return false;
        }
        return knownMethods.contains(method);
    }

    private void addMetadata(FunctionMethod method) {
        String categoryKey = method.getCategory().toUpperCase();
        String nameKey = method.getName().toUpperCase();
        Map functions = null;
        if (this.metadata.containsKey(categoryKey)) {
            functions = (Map)this.metadata.get(categoryKey);
        } else {
            functions = new HashMap();
            this.metadata.put(categoryKey, functions);
        }
        List<FunctionMethod> methods = null;
        if (functions.containsKey(nameKey)) {
            methods = (List)functions.get(nameKey);
        } else {
            methods = new ArrayList();
            functions.put(nameKey, methods);
        }
        methods.add(method);
        ArrayList<FunctionMethod> knownMethods = (ArrayList<FunctionMethod>)this.functionsByName.get(nameKey);
        if (knownMethods == null) {
            knownMethods = new ArrayList<FunctionMethod>();
            this.functionsByName.put(nameKey, knownMethods);
        }
        knownMethods.add(method);
    }

    Collection getCategories() {
        return this.metadata.keySet();
    }

    Collection getFunctionForms(String category) {
        HashSet<FunctionForm> functionForms = new HashSet<FunctionForm>();
        Map functions = (Map)this.metadata.get(category.toUpperCase());
        if (functions != null) {
            Iterator functionIter = functions.values().iterator();
            while (functionIter.hasNext()) {
                List methods = (List)functionIter.next();
                Iterator methodIter = methods.iterator();
                while (methodIter.hasNext()) {
                    FunctionMethod method = (FunctionMethod)methodIter.next();
                    functionForms.add(new FunctionForm(method));
                }
            }
        }
        return functionForms;
    }

    FunctionForm findFunctionForm(String name, int args) {
        List methods = (List)this.functionsByName.get(name.toUpperCase());
        if (methods == null || methods.size() == 0) {
            return null;
        }
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            FunctionMethod method = (FunctionMethod)iter.next();
            if (method.getInputParameterCount() != args) continue;
            return new FunctionForm(method);
        }
        return null;
    }

    private void addFunction(FunctionMetadataSource source, FunctionMethod method) {
        String methodName = method.getName();
        FunctionParameter[] inputParams = method.getInputParameters();
        Class[] inputTypes = null;
        if (inputParams == null) {
            inputTypes = new Class[]{};
        } else {
            inputTypes = new Class[inputParams.length];
            for (int i = 0; i < inputParams.length; ++i) {
                String typeName = inputParams[i].getType();
                inputTypes[i] = DataTypeManager.getDataTypeClass((String)typeName);
            }
        }
        FunctionParameter outputParam = method.getOutputParameter();
        Class outputType = null;
        if (outputParam != null) {
            outputType = DataTypeManager.getDataTypeClass((String)outputParam.getType());
        }
        Object[] path = this.buildPath(methodName, inputTypes);
        FunctionDescriptor descriptor = this.createFunctionDescriptor(source, method, inputTypes, outputType);
        Map node = this.treeRoot;
        for (int pathIndex = 0; pathIndex < path.length; ++pathIndex) {
            Object pathPart = path[pathIndex];
            HashMap children = (HashMap)node.get(pathPart);
            if (children == null) {
                children = new HashMap();
                node.put(pathPart, children);
            }
            node = children;
        }
        node.put(DESCRIPTOR_KEY, descriptor);
    }

    private FunctionDescriptor createFunctionDescriptor(FunctionMetadataSource source, FunctionMethod method, Class[] inputTypes, Class outputType) {
        Method invocationMethod = null;
        boolean requiresContext = false;
        if (method.getPushdown() != 2) {
            Class[] methodSignature = null;
            try {
                try {
                    methodSignature = this.methodSignatureWithContext(inputTypes.length);
                    invocationMethod = this.lookupMethod(source, method.getInvocationClass(), method.getInvocationMethod(), methodSignature);
                    requiresContext = true;
                }
                catch (NoSuchMethodException e) {
                    methodSignature = this.methodSignature(inputTypes.length);
                    invocationMethod = this.lookupMethod(source, method.getInvocationClass(), method.getInvocationMethod(), methodSignature);
                }
            }
            catch (ClassNotFoundException e) {
                invocationMethod = null;
            }
            catch (Exception e) {
                throw new MetaMatrixRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("ERR.015.001.0047", new Object[]{method.getInvocationClass(), invocationMethod, Arrays.asList(methodSignature)}));
            }
        }
        return new FunctionDescriptor(method.getName(), method.getPushdown(), inputTypes, outputType, invocationMethod, requiresContext, method.isNullDependent(), method.getDeterministic());
    }

    private Method lookupMethod(FunctionMetadataSource source, String invocationClass, String invocationMethod, Class[] methodSignature) throws NoSuchMethodException, ClassNotFoundException {
        Class methodClass = source.getInvocationClass(invocationClass);
        Method method = methodClass.getMethod(invocationMethod, methodSignature);
        if (!FunctionTree.isValidMethod(method)) {
            return null;
        }
        return method;
    }

    private Class[] methodSignatureWithContext(int numArgs) {
        Class[] objectSignature = new Class[numArgs + 1];
        objectSignature[0] = class$com$metamatrix$query$util$CommandContext == null ? (class$com$metamatrix$query$util$CommandContext = FunctionTree.class$("com.metamatrix.query.util.CommandContext")) : class$com$metamatrix$query$util$CommandContext;
        for (int i = 1; i < numArgs + 1; ++i) {
            objectSignature[i] = class$java$lang$Object == null ? FunctionTree.class$("java.lang.Object") : class$java$lang$Object;
        }
        return objectSignature;
    }

    private Class[] methodSignature(int numArgs) {
        Class[] objectSignature = new Class[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            objectSignature[i] = class$java$lang$Object == null ? FunctionTree.class$("java.lang.Object") : class$java$lang$Object;
        }
        return objectSignature;
    }

    static boolean isValidMethod(Method method) {
        Class<?> methodReturn = method.getReturnType();
        if (methodReturn.equals(Void.TYPE)) {
            return false;
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        return Modifier.isStatic(modifiers);
    }

    FunctionDescriptor getFunction(String name, Class[] argTypes) {
        Object[] path = this.buildPath(name, argTypes);
        Map node = this.treeRoot;
        for (int i = 0; i < path.length; ++i) {
            if (!node.containsKey(path[i])) {
                return null;
            }
            node = (Map)node.get(path[i]);
        }
        if (node.containsKey(DESCRIPTOR_KEY)) {
            return (FunctionDescriptor)node.get(DESCRIPTOR_KEY);
        }
        return null;
    }

    Collection getPartialFunction(String name, Class[] argTypes) {
        Object[] path = this.buildPath(name, argTypes);
        ArrayList matches = new ArrayList();
        this.helpFindPartialMatch(path, matches);
        return matches;
    }

    private void helpFindPartialMatch(Object[] path, Collection matches) {
        Map node = this.treeRoot;
        for (int i = 0; i < path.length; ++i) {
            Object pathPart = path[i];
            if (pathPart == null) {
                Set possibleNodes = node.keySet();
                Iterator possibleIter = possibleNodes.iterator();
                while (possibleIter.hasNext()) {
                    Object possibleNode = possibleIter.next();
                    if (possibleNode.equals(DESCRIPTOR_KEY)) continue;
                    Object[] pathCopy = new Object[path.length];
                    System.arraycopy(path, 0, pathCopy, 0, path.length);
                    pathCopy[i] = possibleNode;
                    this.helpFindPartialMatch(pathCopy, matches);
                }
                return;
            }
            if (!node.containsKey(pathPart)) break;
            node = (Map)node.get(pathPart);
        }
        if (node.containsKey(DESCRIPTOR_KEY)) {
            matches.add(node.get(DESCRIPTOR_KEY));
        }
    }

    private Object[] buildPath(String name, Class[] argTypes) {
        Object[] path = new Object[argTypes.length + 1];
        path[0] = name.toUpperCase();
        System.arraycopy(argTypes, 0, path, 1, argTypes.length);
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

