/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.FolderDefinitionImpl;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBModelDefn;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.metabase.platform.DirectoryServiceFactory;
import com.metamatrix.metabase.platform.DirectoryServiceProxy;
import com.metamatrix.metabase.repository.MetabaseCoreException;
import com.metamatrix.metabase.repository.internal.message.MessageConstants;
import com.metamatrix.metabase.repository.internal.message.MessageFactory;
import com.metamatrix.metabase.repository.internal.message.RequestMessage;
import com.metamatrix.metabase.repository.internal.message.ResponseMessage;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeVDBDeleteUtility;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnImport;
import com.metamatrix.modeler.core.metadata.runtime.MetadataConstants;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceProxy;
import com.metamatrix.platform.security.api.service.IAuthorizationServiceProxy;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import com.metamatrix.server.admin.apiimpl.RMCNodeComparator;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataHelper;
import com.metamatrix.server.admin.apiimpl.rmc.RMCDefinition;
import com.metamatrix.server.admin.apiimpl.rmc.RMCEntry;
import com.metamatrix.server.admin.apiimpl.rmc.RMCFolderTreeNode;
import com.metamatrix.server.admin.apiimpl.rmc.RMCHelper;
import com.metamatrix.server.admin.apiimpl.rmc.RMCVersionEntry;
import com.metamatrix.server.admin.vdb.VDBExport;
import com.metamatrix.server.util.ServerProxyHelper;
import com.metamatrix.vdb.edit.loader.VDBReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class RuntimeMetadataAdminAPIImpl
extends SubSystemAdminAPIImpl
implements RuntimeMetadataAdminAPI {
    private static RuntimeMetadataAdminAPI runtimeMetadataAdminAPI;

    private RuntimeMetadataAdminAPIImpl() throws MetaMatrixComponentException {
    }

    public static synchronized RuntimeMetadataAdminAPI getInstance() throws MetaMatrixComponentException {
        if (runtimeMetadataAdminAPI == null) {
            runtimeMetadataAdminAPI = new RuntimeMetadataAdminAPIImpl();
        }
        return runtimeMetadataAdminAPI;
    }

    public synchronized TreeNode getRMCs() throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)"RuntimeMetadataAdminAPIImpl.getRMCs()");
        RMCFolderTreeNode root = new RMCFolderTreeNode(null, "Metabase Repository (VDB Definitions)", (ObjectDefinition)new FolderDefinitionImpl(), IDGenerator.getInstance().create());
        DTCDirectory DTCdir = new DTCDirectory(callerToken);
        try {
            root = DTCdir.getAllRMCs(root);
        }
        catch (MetaMatrixException me) {
            String msg = ServerPlugin.Util.getString("ERR.018.001.0003");
            MetaMatrixComponentException e = new MetaMatrixComponentException((Throwable)me, "ERR.018.001.0003", msg);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        catch (IOException ioe) {
            String msg = ServerPlugin.Util.getString("ERR.018.001.0003");
            MetaMatrixComponentException e = new MetaMatrixComponentException((Throwable)ioe, "ERR.018.001.0003", msg);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        return root;
    }

    public synchronized TreeNode getRMCVersions(RMCFolderTreeNode rmcFolder) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.getRMCVersions(" + rmcFolder + ")"));
        RMCFolderTreeNode result = null;
        DTCDirectory DTCdir = new DTCDirectory(callerToken);
        try {
            result = DTCdir.getRMCVersions(rmcFolder);
        }
        catch (MetaMatrixException me) {
            String msg = ServerPlugin.Util.getString("ERR.018.001.0003");
            MetaMatrixComponentException e = new MetaMatrixComponentException((Throwable)me, "ERR.018.001.0003", msg);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        catch (IOException ioe) {
            String msg = ServerPlugin.Util.getString("ERR.018.001.0003");
            MetaMatrixComponentException e = new MetaMatrixComponentException((Throwable)ioe, "ERR.018.001.0003", msg);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        return result;
    }

    public synchronized RMCVersionEntry populateRMCWithVDBArchive(RMCVersionEntry entry) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.populateRMCWithVDBArchive(" + entry + ")"));
        DTCDirectory DTCdir = new DTCDirectory(callerToken);
        entry = DTCdir.getVDBArchive(entry);
        return entry;
    }

    public synchronized void updateVirtualDatabase(VirtualDatabase vdb) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.updateVirtualDatabase(" + vdb.getID() + ")"));
        RuntimeMetadataCatalog.updateVirtualDatabase((VirtualDatabase)vdb, (String)callerToken.getUsername());
    }

    public synchronized void markVDBForDelete(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.markVDBForDelete(" + vdbID + ")"));
        VirtualDatabase theVDB = RuntimeMetadataCatalog.getVirtualDatabase((VirtualDatabaseID)vdbID);
        short vdbStatus = theVDB.getStatus();
        if (vdbStatus == 4) {
            return;
        }
        if (vdbStatus != 2 && vdbStatus != 1) {
            String msg = ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Can_t_delete_VDB_in_state_{0}", new Object[]{MetadataConstants.getVDBStatusName((short)vdbStatus)});
            throw new VirtualDatabaseException(msg);
        }
        RuntimeMetadataCatalog.setVDBStatus((VirtualDatabaseID)vdbID, (short)4, (String)callerToken.getUsername());
        RuntimeVDBDeleteUtility vdbDeleter = new RuntimeVDBDeleteUtility();
        vdbDeleter.deleteVDBMarkedForDelete(vdbID);
    }

    public synchronized Map migrateConnectorBindingNames(VirtualDatabase sourceVDB, RMCVersionEntry dtc) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        HashMap<String, List> modelNameToRoutingIDs = new HashMap<String, List>();
        ArrayList<String> modelNames = new ArrayList<String>();
        Iterator modelItr = dtc.getModels().iterator();
        while (modelItr.hasNext()) {
            VDBModelDefn model = (VDBModelDefn)modelItr.next();
            String modelName = model.getName();
            modelNameToRoutingIDs.put(modelName, Collections.EMPTY_LIST);
            modelNames.add(modelName);
        }
        short stateFlag = 3;
        VirtualDatabase currentVDB = sourceVDB;
        VirtualDatabaseID currentVDBID = sourceVDB.getVirtualDatabaseID();
        do {
            Iterator currentModels = RuntimeMetadataCatalog.getModels((VirtualDatabaseID)currentVDB.getVirtualDatabaseID()).iterator();
            while (currentModels.hasNext()) {
                Model model = (Model)currentModels.next();
                String modelName = model.getName();
                if (!modelNames.contains(modelName)) continue;
                List cbNames = model.getConnectorBindingNames();
                modelNameToRoutingIDs.put(modelName, cbNames);
                if (cbNames.size() <= 0) continue;
                modelNames.remove(modelName);
            }
            int currentVers = Integer.parseInt(currentVDBID.getVersion());
            if ((currentVDB = RuntimeMetadataHelper.walkBack(currentVDB.getName(), currentVers, stateFlag)) == null) continue;
            currentVDBID = currentVDB.getVirtualDatabaseID();
        } while (currentVDB != null && modelNames.size() > 0);
        return modelNameToRoutingIDs;
    }

    public synchronized void setConnectorBindingNames(VirtualDatabaseID vdbID, Map modelAndCBNames) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.setConnectorBindingNames(" + vdbID + ", " + modelAndCBNames + ")"));
        try {
            RuntimeMetadataCatalog.setConnectorBindingNames((VirtualDatabaseID)vdbID, (Map)modelAndCBNames, (String)callerToken.getUsername());
        }
        catch (VirtualDatabaseException e) {
            LogManager.logError((String)"RUNTIME_METADATA_ADMIN_API", (Throwable)e, (String)ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Unable_to_set_connector_bindings."));
            throw e;
        }
    }

    public synchronized Map getConnectorBindingNames(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        Collection models = RuntimeMetadataCatalog.getModels((VirtualDatabaseID)vdbID);
        HashMap<MetadataID, String> modelIDsCBNames = new HashMap<MetadataID, String>();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            Model model = (Model)iter.next();
            List cbNames = model.getConnectorBindingNames();
            Iterator mit = cbNames.iterator();
            while (mit.hasNext()) {
                String cbName = (String)mit.next();
                modelIDsCBNames.put(model.getID(), cbName);
            }
        }
        return modelIDsCBNames;
    }

    public synchronized Collection getVDBsForConnectorBinding(String routingID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        HashSet<VirtualDatabase> VDBs = new HashSet<VirtualDatabase>();
        Iterator allVDBItr = RuntimeMetadataCatalog.getVirtualDatabases().iterator();
        boolean found = false;
        while (allVDBItr.hasNext()) {
            found = false;
            VirtualDatabase aVDB = (VirtualDatabase)allVDBItr.next();
            Iterator modelItr = RuntimeMetadataCatalog.getModels((VirtualDatabaseID)aVDB.getVirtualDatabaseID()).iterator();
            block1: while (!found && modelItr.hasNext()) {
                Model model = (Model)modelItr.next();
                List cbNames = model.getConnectorBindingNames();
                Iterator mit = cbNames.iterator();
                while (mit.hasNext()) {
                    String connectorBindingName = (String)mit.next();
                    if (connectorBindingName == null || !connectorBindingName.equals(routingID)) continue;
                    VDBs.add(aVDB);
                    found = true;
                    continue block1;
                }
            }
        }
        return VDBs;
    }

    public synchronized VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        return RuntimeMetadataCatalog.getVirtualDatabase((VirtualDatabaseID)vdbID);
    }

    public synchronized VirtualDatabase getLatestVirtualDatabase(String vdbName) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        VirtualDatabaseID vdbId = RuntimeMetadataCatalog.getVirtualDatabaseID((String)vdbName, null);
        if (vdbId != null) {
            return RuntimeMetadataCatalog.getVirtualDatabase((VirtualDatabaseID)vdbId);
        }
        return null;
    }

    public synchronized Collection getVirtualDatabases() throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        return RuntimeMetadataCatalog.getVirtualDatabases();
    }

    public synchronized Collection getVDBModels(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        ArrayList models = new ArrayList(RuntimeMetadataCatalog.getModels((VirtualDatabaseID)vdbID));
        int sysModelIndex = -1;
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            if (!model.getName().equals("SystemPhysical")) continue;
            sysModelIndex = i;
            break;
        }
        if (sysModelIndex >= 0) {
            models.remove(sysModelIndex);
        }
        int sysAdminModelIndex = -1;
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            if (!model.getName().equals("SystemAdminPhysical")) continue;
            sysAdminModelIndex = i;
            break;
        }
        if (sysAdminModelIndex >= 0) {
            models.remove(sysAdminModelIndex);
        }
        return models;
    }

    public synchronized void setVDBState(VirtualDatabaseID vdbID, short state) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.setVDBState(" + vdbID + ", " + state + ")"));
        VirtualDatabase theVDB = RuntimeMetadataCatalog.getVirtualDatabase((VirtualDatabaseID)vdbID);
        short vdbStatus = theVDB.getStatus();
        if (vdbStatus == 4 || vdbStatus == state) {
            return;
        }
        if (!(vdbStatus == 2 && state == 3 || vdbStatus == 3 && state == 2)) {
            String msg = ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Can__t_set_VDB_state_from_{0}_to_{1}", new Object[]{MetadataConstants.getVDBStatusName((short)vdbStatus), MetadataConstants.getVDBStatusName((short)state)});
            VirtualDatabaseException e = new VirtualDatabaseException(msg);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        RuntimeMetadataCatalog.setVDBStatus((VirtualDatabaseID)vdbID, (short)state, (String)callerToken.getUsername());
        RuntimeMetadataCatalog.setVDBStatus((VirtualDatabaseID)vdbID, (short)state, (String)callerToken.getUsername());
    }

    public synchronized EntitlementMigrationReport migrateEntitlements(VirtualDatabase sourceVDB, VirtualDatabase targetVDB) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        HashSet<String> requiredRole = new HashSet<String>();
        requiredRole.add("Admin.MetaMatrix Server.ProductAdmin");
        requiredRole.add("Admin.System.UserAdmin");
        AdminAPIHelper.checkForRequiredRole((SessionToken)token, requiredRole, (String)("RuntimeMetadataAdminAPIImpl.migrateEntitlements(" + sourceVDB.getID() + ", " + targetVDB.getID() + ")"));
        return RuntimeMetadataHelper.migrateEntitlements(sourceVDB, targetVDB, token);
    }

    public synchronized PermissionDataNode getEntitlementTree(String vDBName, String vDBVersion, AuthorizationPolicyID policyID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)("getEntitlementTree: Getting entitlements for policy: [" + policyID + "]"));
        AuthorizationServiceProxy authProxy = ServerProxyHelper.getAuthorizationServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        authProxy.connect();
        PermissionDataNodeImpl root = RuntimeMetadataHelper.getPermissionDataNodes(new AuthorizationRealm(vDBName, vDBVersion, null), policyID, (IAuthorizationServiceProxy)authProxy);
        LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)("getEntitlementTree: Root has [" + root.getChildCount() + "] children."));
        return root;
    }

    public synchronized PermissionDataNode getDataNodes(String vDBName, String vDBVersion) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)("getDataNodes: Getting data nodes for VDB: [" + vDBName + "] Vers: [" + vDBVersion + "]"));
        PermissionDataNodeImpl root = RuntimeMetadataHelper.getDataNodes(vDBName, vDBVersion);
        return root;
    }

    public synchronized Set getAllDataNodeNames(String vdbName, String vdbVersion) throws InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        return new HashSet(RuntimeMetadataHelper.getAllDataNodeNames(vdbName, vdbVersion, new HashMap()));
    }

    public synchronized VDBDefn getVDBDefn(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.getVDBDefn(" + vdbID + ")"));
        try {
            VDBDefn vdbDefn = VDBExport.getVDBDefn((String)vdbID.getName(), (String)vdbID.getVersion());
            return vdbDefn;
        }
        catch (VirtualDatabaseException e) {
            String msg = ServerPlugin.Util.getString("ERR.018.001.0007");
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)e);
            }
            if (e instanceof InvalidSessionException) {
                throw (InvalidSessionException)((Object)e);
            }
            if (e instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)((Object)e);
            }
            throw new MetaMatrixComponentException((Throwable)e, ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Error_getting_VDBDefn_for_{0}") + vdbID);
        }
    }

    public synchronized VirtualDatabase importVDB(VDBDefn vdbDefn) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        AdminAPIHelper.checkForRequiredRole((SessionToken)callerToken, (String)"Admin.MetaMatrix Server.ProductAdmin", (String)("RuntimeMetadataAdminAPIImpl.importVDB(" + vdbDefn + ")"));
        try {
            return VDBDefnImport.importVDBDefn((VDBDefn)vdbDefn, (String)callerToken.getUsername());
        }
        catch (VirtualDatabaseException e) {
            String msg = ServerPlugin.Util.getString("ERR.018.001.0007");
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)e);
            }
            if (e instanceof InvalidSessionException) {
                throw (InvalidSessionException)((Object)e);
            }
            if (e instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)((Object)e);
            }
            Object[] params = new Object[]{vdbDefn.getFileName()};
            String msg = ServerPlugin.Util.getString("ERR.018.001.0008", params);
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0008", msg);
        }
    }

    public synchronized Map getModelVisibilityLevels(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession((MetaMatrixSessionID)this.getSessionID());
        Collection models = RuntimeMetadataCatalog.getModels((VirtualDatabaseID)vdbID);
        HashMap<MetadataID, Short> modelIDsVLevels = new HashMap<MetadataID, Short>();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            Model model = (Model)iter.next();
            modelIDsVLevels.put(model.getID(), new Short(model.getVisibility()));
        }
        return modelIDsVLevels;
    }

    public boolean validateConnectorBindingForMaterialization(ConnectorBinding materializationConnector) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        return true;
    }

    public MaterializationLoadScripts getMaterializationScripts(ConnectorBinding materializationConnector, RMCVersionEntry vdb, String mmHost, String mmPort, String materializationUserName, String materializationUserPwd, String metamatrixUserName, String metamatrixPwd) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        if (vdb == null) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.VDB_null"));
        }
        if (materializationUserName == null || materializationUserName.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.materializationUserName_null"));
        }
        if (materializationUserPwd == null || materializationUserPwd.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.materializationUserPwd_null"));
        }
        if (metamatrixUserName == null || metamatrixUserName.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.metamatrixUserName_null"));
        }
        if (metamatrixPwd == null || metamatrixPwd.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.metamatrixPwd_null"));
        }
        ModelInfo materializationModel = vdb.getMatertializationModel();
        if (materializationModel == null) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.VDB_has_no_materialziation"));
        }
        String vdbName = vdb.getName();
        int dotIndex = vdbName.indexOf(46);
        if (dotIndex >= 0) {
            vdbName = vdbName.substring(0, dotIndex);
        }
        String vdbVersion = vdb.getVersion();
        Properties connectorProps = materializationConnector.getProperties();
        String matURL = connectorProps.getProperty("URL");
        String matDriver = connectorProps.getProperty("Driver");
        if (mmHost == null) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.MetaMatrix_host_null"));
        }
        try {
            Integer.parseInt(mmPort);
        }
        catch (NumberFormatException err) {
            Object[] params = new Object[]{mmPort};
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Expected_integer_for_port {0}", params));
        }
        String mmDriver = "com.metamatrix.jdbc.MMDriver";
        boolean useSSL = false;
        try {
            useSSL = SocketHelper.isServerSSLEnabled();
        }
        catch (Exception err) {
            throw new MetaMatrixRuntimeException(ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Unable_to_determine_ssl_mode"));
        }
        try {
            metamatrixPwd = PropertiesUtils.saveConvert((String)new String(CryptoUtil.stringEncrypt((char[])metamatrixPwd.toCharArray())), (boolean)false);
            materializationUserPwd = PropertiesUtils.saveConvert((String)new String(CryptoUtil.stringEncrypt((char[])materializationUserPwd.toCharArray())), (boolean)false);
        }
        catch (CryptoException err1) {
            Object[] params = new Object[]{vdbName};
            throw new MetaMatrixRuntimeException((Throwable)err1, ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Unable_to_encrypt_pwd", params));
        }
        MaterializationLoadScripts scripts = RuntimeMetadataHelper.createMaterializedViewLoadProperties(materializationModel, matURL, matDriver, materializationUserName, materializationUserPwd, mmHost, mmPort, mmDriver, useSSL, metamatrixUserName, metamatrixPwd, vdbName, vdbVersion);
        return scripts;
    }

    class DTCDirectory {
        private DirectoryServiceProxy dsProxy;
        private String userName;
        private MetaMatrixSessionID sessionId;

        public DTCDirectory(SessionToken token) throws ServiceException {
            this.userName = token.getUsername();
            this.sessionId = token.getSessionID();
            try {
                this.dsProxy = DirectoryServiceFactory.getDirectoryServiceProxy();
            }
            catch (RegistryException e) {
                throw new ServiceException((Throwable)e, ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Error_creating_DirectoryServiceProxy:_{0}", (Object)token.getSessionID()));
            }
        }

        public RMCFolderTreeNode getAllRMCs(RMCFolderTreeNode root) throws MetaMatrixException, IOException {
            LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)"getAllRMCs");
            Collection rmcs = null;
            try {
                String vdbArchiveName = MessageConstants.EntryTypeElementValues.getItemTypeName((int)MessageConstants.EntryTypeElementValues.VDB_ARCHIVE_INT_VALUE);
                String msg = "CREATE REQUEST-command getChildren IPath " + Path.ROOT + " EntryType " + vdbArchiveName;
                LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"*** REQUEST ALL RMCS ***", msg});
                RequestMessage mr = MessageFactory.createRequest((String)"getChildren", (IPath)Path.ROOT, null, (String)this.userName, (String)MessageConstants.EntryTypeElementValues.VDB_ARCHIVE_STRING_VALUE, (int)2);
                Object response = this.submit(this.sessionId, this.userName, mr);
                rmcs = RMCHelper.createRMCEntriesForResponse((String)((ResponseMessage)response).getXmlMessageString());
            }
            catch (MetabaseCoreException mce) {
                String msg = ServerPlugin.Util.getString("ERR.018.001.0010");
                MetaMatrixException e = new MetaMatrixException((Throwable)mce, msg);
                ServerPlugin.Util.log(4, (Throwable)e, msg);
                throw e;
            }
            LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"getAllRMCs: Root [", root.getName(), "] has RMCs [", new Integer(rmcs.size()), "]"});
            RMCFolderTreeNode newRoot = this.buildRMCTree(root, rmcs);
            return newRoot;
        }

        public RMCFolderTreeNode getRMCVersions(RMCFolderTreeNode root) throws MetaMatrixException, IOException {
            LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)"getAllRMCs");
            RMCDefinition rmcDef = (RMCDefinition)root.getType();
            RMCEntry rmc = rmcDef.getRMCEntry();
            List rmcs = null;
            Path p = new Path(rmc.getPathWithName());
            try {
                String msg = "CREATE REQUEST-command getChildren IPath " + rmc.getPathWithName() + " EntryType " + MessageConstants.EntryTypeElementValues.VDB_ARCHIVE_STRING_VALUE;
                LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"*** REQUEST VERSIONS ***", msg});
                RequestMessage mr = MessageFactory.createRequest((String)"getHistory", (IPath)p, null, (String)this.userName, (String)MessageConstants.EntryTypeElementValues.VDB_ARCHIVE_STRING_VALUE, (int)0);
                Object response = this.submit(this.sessionId, this.userName, mr);
                rmcs = RMCHelper.createRMCVersionsForResponse((RMCEntry)rmc, (String)((ResponseMessage)response).getXmlMessageString());
                Collections.sort(rmcs, new RMCNodeComparator());
                LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"getRMCVersions: VDB [", p, "] has # versions [", new Integer(rmcs.size()), "]"});
                Iterator eIt = rmcs.iterator();
                while (eIt.hasNext()) {
                    RMCVersionEntry rmcv = (RMCVersionEntry)eIt.next();
                    RuntimeMetadataHelper.makeRMCVersionNode(rmcv, root);
                }
            }
            catch (MetabaseCoreException mce) {
                String msg = ServerPlugin.Util.getString("ERR.018.001.0010");
                MetaMatrixException e = new MetaMatrixException((Throwable)mce, msg);
                ServerPlugin.Util.log(4, (Throwable)e, msg);
                throw e;
            }
            return root;
        }

        private RMCVersionEntry getVDBArchive(RMCVersionEntry entry) throws VirtualDatabaseException, MetaMatrixComponentException {
            LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)"getVDBArchive");
            try {
                Path p = new Path(entry.getPathWithName());
                String msg = "CREATE ARCHIVE REQUEST-command getVersion IPath " + p + " For Entry " + entry.getName();
                LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"*** REQUEST get VDB archive Version ***", msg});
                RequestMessage mr = MessageFactory.createRequest((String)"getVersion", (IPath)p, (String)entry.getVersion(), (String)this.userName, (String)MessageConstants.EntryTypeElementValues.FILE_STRING_VALUE, (int)0);
                LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"Get Version", mr.toString()});
                ResponseMessage response = (ResponseMessage)this.submit(this.sessionId, this.userName, mr);
                byte[] archiveContents = response.getContent();
                if (archiveContents == null || archiveContents.length == 0) {
                    String emsg = ServerPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.VDB_Archive_from_metabase_repository_is_null_1", (Object)entry.getPathWithName());
                    ServerPlugin.Util.log(2, emsg);
                    return entry;
                }
                VDBDefn vdbDefn = VDBReader.loadVDBDefn((VDBDefn)entry, archiveContents);
                entry = new RMCVersionEntry(vdbDefn);
                LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (String)entry.getPathWithName());
                return entry;
            }
            catch (VirtualDatabaseException mce) {
                throw mce;
            }
            catch (MetaMatrixComponentException mce) {
                throw mce;
            }
            catch (Exception mce) {
                String msg = ServerPlugin.Util.getString("ERR.018.001.0010");
                MetaMatrixComponentException e = new MetaMatrixComponentException((Throwable)mce, msg);
                ServerPlugin.Util.log(4, (Throwable)e, msg);
                throw e;
            }
        }

        private RMCFolderTreeNode buildRMCTree(RMCFolderTreeNode parent, Collection rmcs) throws MetaMatrixException, IOException {
            HashMap entriesByPath = new HashMap();
            ArrayList<String> sortedEntriesByPath = new ArrayList<String>(rmcs.size());
            Collection entryForPath = null;
            RMCEntry ei = null;
            HashMap<String, Path> sortedMap = new HashMap<String, Path>();
            Iterator rmcIt = rmcs.iterator();
            while (rmcIt.hasNext()) {
                ei = (RMCEntry)rmcIt.next();
                LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (String)("Build Tree from RMC [" + ei.getPathWithName() + "] >"));
                Path entryPath = new Path(ei.getPathWithName());
                Object parentPath = null;
                parentPath = entryPath.isRoot() ? entryPath : entryPath.removeLastSegments(1);
                entryForPath = entriesByPath.containsKey(parentPath) ? (Collection)entriesByPath.get(parentPath) : new ArrayList();
                entryForPath.add(ei);
                entriesByPath.put((Path)parentPath, entryForPath);
                String p = parentPath.toFile().getAbsolutePath();
                if (sortedEntriesByPath.contains(p)) continue;
                sortedEntriesByPath.add(p);
                sortedMap.put(p, (Path)parentPath);
            }
            if (entriesByPath.isEmpty()) {
                return parent;
            }
            HashMap treeNodeMap = new HashMap();
            Collections.sort(sortedEntriesByPath);
            RMCFolderTreeNode pathNode = null;
            Iterator pathIt = sortedEntriesByPath.iterator();
            while (pathIt.hasNext()) {
                String pathMap = (String)pathIt.next();
                IPath pathKey = (IPath)sortedMap.get(pathMap);
                List entries = (List)entriesByPath.get(pathKey);
                Collections.sort(entries, new RMCNodeComparator());
                LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (String)("BuildTree - PathKey  [" + pathKey.toString() + "] >"));
                if (!pathKey.isRoot()) {
                    LogManager.logTrace((String)"RUNTIME_METADATA_ADMIN_API", (String)("BuildTree - Make Path Node [" + pathKey.toString() + "] >"));
                    pathNode = RuntimeMetadataHelper.makePathNode(parent, treeNodeMap, pathKey.toString(), '/');
                } else {
                    pathNode = parent;
                }
                Iterator eIt = entries.iterator();
                while (eIt.hasNext()) {
                    RMCEntry rmc = (RMCEntry)eIt.next();
                    RMCFolderTreeNode vdbNode = RuntimeMetadataHelper.makeRMCVDBNode(pathNode, treeNodeMap, rmc);
                    this.getRMCVersions(vdbNode);
                }
            }
            return parent;
        }

        protected Object submit(MetaMatrixSessionID sessionId, String userName, RequestMessage message) throws MetaMatrixException {
            try {
                return this.dsProxy.submitRequest(sessionId, userName, message);
            }
            catch (Exception e) {
                String msg = ServerPlugin.Util.getString("ERR.018.001.0013");
                throw new MetaMatrixException((Throwable)e, "ERR.018.001.0013", msg);
            }
        }
    }
}

