/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.Stack;

public final class RuleValidateWhereAll
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Stack<Object> nodes = new Stack<Object>();
        nodes.push(plan);
        while (!nodes.isEmpty()) {
            PlanNode node = (PlanNode)nodes.pop();
            if (node.getType() == 3) {
                boolean hasNoCriteria;
                boolean supportsWhereAll;
                Object modelID = node.getProperty((Object)NodeConstants.Info.MODEL_ID);
                if (modelID == null) {
                    modelID = RuleRaiseAccess.getModelIDFromAccess(node, metadata);
                    node.setProperty((Object)NodeConstants.Info.MODEL_ID, modelID);
                }
                if (modelID != null && !(supportsWhereAll = metadata.modelSupports(modelID, 3)) && (hasNoCriteria = RuleValidateWhereAll.hasNoCriteria((Command)node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST)))) {
                    if (node.getType() == 3 && node.getProperty((Object)NodeConstants.Info.DEPENDENT_ELEMENT) == null) {
                        String modelName = metadata.getFullName(modelID);
                        throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0024", (Object)modelName));
                    }
                    node.setProperty((Object)NodeConstants.Info.ALLOWS_NO_CRITERIA, (Object)supportsWhereAll);
                }
            }
            Iterator children = node.getChildren().iterator();
            while (children.hasNext()) {
                nodes.push(children.next());
            }
        }
        return plan;
    }

    static boolean hasNoCriteria(Command command) {
        if (command instanceof Query) {
            Query query = (Query)command;
            return query.getCriteria() == null;
        }
        return false;
    }

    public String toString() {
        return "ValidateWhereAll";
    }
}

