/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class RulePushSelectCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean movedAnyNode = true;
        HashSet<PlanNode> deadNodes = new HashSet<PlanNode>();
        while (movedAnyNode) {
            PlanNode critNode;
            movedAnyNode = false;
            ArrayList critNodes = new ArrayList();
            this.findSingleGroupCriteria(plan, critNodes, deadNodes, metadata, capFinder);
            Iterator nodeIter = critNodes.iterator();
            while (nodeIter.hasNext()) {
                critNode = (PlanNode)nodeIter.next();
                this.pushWithinFrame(critNode, metadata, capFinder);
            }
            nodeIter = critNodes.iterator();
            while (nodeIter.hasNext()) {
                critNode = (PlanNode)nodeIter.next();
                if (!FrameUtil.hasSubquery(critNode)) {
                    if (critNode.getGroups().size() > 0 && this.pushAcrossFrame(plan, critNode, metadata)) {
                        movedAnyNode = true;
                        continue;
                    }
                    if (this.pushAcrossUnion(plan, critNode, deadNodes, metadata)) {
                        movedAnyNode = true;
                        continue;
                    }
                    if (this.pushAcrossGroupBy(plan, critNode)) {
                        movedAnyNode = true;
                        continue;
                    }
                    deadNodes.add(critNode);
                    continue;
                }
                deadNodes.add(critNode);
            }
        }
        if (rules.contains(RuleConstants.ACCESS_PATTERN_VALIDATION)) {
            rules.push(RuleConstants.CHOOSE_ACCESS_PATTERN);
        }
        return plan;
    }

    void findSingleGroupCriteria(PlanNode root, List foundNodes, Set deadNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        if (!deadNodes.contains(root) && root.getType() == 13 && root.getGroups().size() <= 1) {
            boolean isHaving = Boolean.TRUE.equals(root.getProperty((Object)NodeConstants.Info.IS_HAVING));
            boolean isPhantom = Boolean.TRUE.equals(root.getProperty((Object)NodeConstants.Info.IS_PHANTOM));
            if (!isHaving && !isPhantom) {
                boolean hasSubquery = FrameUtil.hasSubquery(root);
                if (!hasSubquery || CapabilitiesUtil.isEligibleSubquery(root, metadata, capFinder)) {
                    foundNodes.add(root);
                }
                if (this.isFrameOnInnerSideOfOuterJoinThatMayBePushedToSource(root, metadata, capFinder)) {
                    root.setProperty((Object)NodeConstants.Info.INNER_SIDE_OF_OUTER_JOIN, (Object)Boolean.TRUE);
                }
            }
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findSingleGroupCriteria(child, foundNodes, deadNodes, metadata, capFinder);
            }
        }
    }

    PlanNode findSourceNode(PlanNode root, GroupSymbol group) {
        if (root.getType() == 19) {
            if (root.getGroups().contains(group) || group == null) {
                return root;
            }
            return null;
        }
        List children = root.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            PlanNode found = this.findSourceNode(child, group);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    boolean pushWithinFrame(PlanNode critNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode sourceNode;
        block5: {
            block6: {
                block4: {
                    sourceNode = null;
                    if (critNode.getGroups().size() <= 0) break block4;
                    GroupSymbol sourceGroup = (GroupSymbol)critNode.getGroups().iterator().next();
                    sourceNode = this.findSourceNode(critNode, sourceGroup);
                    break block5;
                }
                if (FrameUtil.hasSubquery(critNode)) break block6;
                Criteria c = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                if (ReferenceCollectorVisitor.getReferences((LanguageObject)c).size() <= 0) break block5;
                sourceNode = this.findSourceNode(critNode, null);
                break block5;
            }
            Object modelID = this.getUniqueModel(critNode, metadata);
            if (modelID == null) {
                return false;
            }
            List allSrcNodes = NodeEditor.findAllNodes(critNode, 19);
            Iterator iter = allSrcNodes.iterator();
            while (iter.hasNext()) {
                PlanNode node = (PlanNode)iter.next();
                Set groups = node.getGroups();
                GroupSymbol group = (GroupSymbol)groups.iterator().next();
                Object srcModelID = metadata.getModelID(group.getMetadataID());
                if (srcModelID == null || !srcModelID.equals(modelID)) continue;
                sourceNode = node;
                break;
            }
        }
        if (sourceNode == null) {
            return false;
        }
        PlanNode[] destination = this.examinePath(critNode, sourceNode, metadata, capFinder);
        if (destination != null && destination[0] != null) {
            boolean shouldRemove = this.shouldRemoveOriginal(critNode, destination[0]);
            this.moveNodeWithinFrame(critNode, destination[0], destination[1], shouldRemove);
            RulePushSelectCriteria.recontextCorrelatedReferenceGroups(critNode, metadata);
            return true;
        }
        return false;
    }

    private Object getUniqueModel(PlanNode critNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        List plans = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        if (plans == null) {
            return null;
        }
        Iterator planIter = plans.iterator();
        while (planIter.hasNext()) {
            Object plan = planIter.next();
            if (!(plan instanceof RelationalPlan)) continue;
            RelationalPlan subPlan = (RelationalPlan)plan;
            LinkedList<RelationalNode> nodes = new LinkedList<RelationalNode>();
            nodes.add(subPlan.getRootNode());
            while (nodes.size() > 0) {
                RelationalNode node = (RelationalNode)nodes.removeFirst();
                if (node instanceof AccessNode) {
                    Command command = ((AccessNode)node).getCommand();
                    Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, (boolean)true);
                    if (groups.size() <= 0) continue;
                    GroupSymbol group = (GroupSymbol)groups.iterator().next();
                    if (modelID == null) {
                        modelID = metadata.getModelID(group.getMetadataID());
                        continue;
                    }
                    if (modelID.equals(metadata.getModelID(group.getMetadataID()))) continue;
                    return null;
                }
                RelationalNode[] children = node.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] == null) continue;
                    nodes.add(children[i]);
                }
            }
        }
        return modelID;
    }

    private boolean isFrameOnInnerSideOfOuterJoinThatMayBePushedToSource(PlanNode node, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode parent = node.getParent();
        if (!node.getGroups().isEmpty()) {
            GroupSymbol possibleInnerGroup = (GroupSymbol)node.getGroups().iterator().next();
            while (parent != null) {
                JoinPredicate outerJoinPredicate;
                From from;
                if (parent.getType() == 19) {
                    possibleInnerGroup = (GroupSymbol)parent.getGroups().iterator().next();
                } else if (parent.getType() == 7 && possibleInnerGroup != null && (from = (From)parent.getProperty((Object)NodeConstants.Info.FROM_CLAUSE)) != null && (outerJoinPredicate = from.getOuterJoinPredicateForInnerSideGroupSymbol(possibleInnerGroup)) != null) {
                    return this.isJoinPushableToSource(parent, outerJoinPredicate, metadata, capFinder);
                }
                node = parent;
                parent = node.getParent();
            }
        }
        return false;
    }

    private boolean isJoinPushableToSource(PlanNode joinNode, JoinPredicate outerJoinPredicate, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        boolean REMOVE_DUPLICATES = true;
        Collection joinPredicateGroups = GroupCollectorVisitor.getGroups((LanguageObject)outerJoinPredicate, (boolean)true);
        Object modelID = null;
        Collection physicalModelIDs = this.findPhysicalModelIDsForJoin(joinNode, joinPredicateGroups, metadata);
        Iterator j = physicalModelIDs.iterator();
        while (j.hasNext()) {
            Object tempModelID = j.next();
            if (modelID == null) {
                modelID = tempModelID;
                continue;
            }
            if (modelID.equals(tempModelID)) continue;
            modelID = null;
            break;
        }
        if (modelID != null) {
            try {
                if (CapabilitiesUtil.supportsOuterJoin(modelID, outerJoinPredicate.getJoinType(), metadata, capFinder)) {
                    return true;
                }
            }
            catch (QueryMetadataException e) {
                throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0021", modelID));
            }
        }
        return false;
    }

    private Collection findPhysicalModelIDsForJoin(PlanNode joinNode, Collection joinPredicateGroups, QueryMetadataInterface metadata) throws QueryPlannerException, MetaMatrixComponentException {
        HashSet physicalModelIDs = new HashSet();
        List sourceNodes = NodeEditor.findAllNodes(joinNode, 19, 19);
        Iterator i = sourceNodes.iterator();
        while (i.hasNext()) {
            PlanNode sourceNode = (PlanNode)i.next();
            GroupSymbol sourceNodeGroup = (GroupSymbol)sourceNode.getGroups().iterator().next();
            if (!joinPredicateGroups.contains(sourceNodeGroup)) continue;
            this.findPhysicalModelIDsForSourceNode(sourceNode, metadata, physicalModelIDs);
        }
        return physicalModelIDs;
    }

    private void findPhysicalModelIDsForSourceNode(PlanNode sourceNode, QueryMetadataInterface metadata, Collection physicalModelIDs) throws QueryPlannerException, MetaMatrixComponentException {
        ArrayList<PlanNode> sourceNodes = new ArrayList<PlanNode>();
        sourceNodes.add(sourceNode);
        sourceNodes.addAll(NodeEditor.findAllNodes(sourceNode, 19));
        Iterator i = sourceNodes.iterator();
        while (i.hasNext()) {
            PlanNode queuedSourceNode = (PlanNode)i.next();
            GroupSymbol nodeGroup = (GroupSymbol)queuedSourceNode.getGroups().iterator().next();
            boolean isVirtual = false;
            try {
                isVirtual = metadata.isVirtualGroup(nodeGroup.getMetadataID());
            }
            catch (QueryMetadataException e) {
                throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0071", nodeGroup.getMetadataID()));
            }
            if (isVirtual) continue;
            try {
                physicalModelIDs.add(metadata.getModelID(nodeGroup.getMetadataID()));
            }
            catch (QueryMetadataException e) {
                throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0020", nodeGroup.getMetadataID()));
            }
        }
    }

    PlanNode[] examinePath(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode currentNode;
        if (sourceNode == null || sourceNode.getParent() == critNode) {
            return null;
        }
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Stack<PlanNode> path = new Stack<PlanNode>();
        for (currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            path.push(currentNode);
        }
        PlanNode destinationParent = null;
        PlanNode destinationChild = null;
        while (!path.empty()) {
            currentNode = (PlanNode)path.pop();
            if (currentNode.getType() == 3) {
                if (critNode.getGroups().size() > 0) {
                    Iterator groupIter = critNode.getGroups().iterator();
                    GroupSymbol group = (GroupSymbol)groupIter.next();
                    try {
                        if (metadata.isTemporaryGroup(group.getMetadataID())) {
                            destinationChild = currentNode;
                            break;
                        }
                        Object modelID = metadata.getModelID(group.getMetadataID());
                        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)crit, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
                            destinationChild = currentNode;
                            break;
                        }
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0020", (Object)group));
                    }
                }
            } else {
                if (currentNode.getType() == 23) {
                    destinationChild = currentNode;
                    break;
                }
                if (currentNode.getType() == 29) {
                    destinationChild = currentNode;
                    break;
                }
                if (currentNode.getType() == 7 && RulePushSelectCriteria.isInnerSideOfOuterJoin(currentNode, crit)) {
                    destinationChild = currentNode;
                    break;
                }
            }
            destinationParent = currentNode;
        }
        if (destinationChild == null) {
            destinationChild = path.isEmpty() ? sourceNode : (PlanNode)path.pop();
        }
        return new PlanNode[]{destinationParent, destinationChild};
    }

    static boolean isInnerSideOfOuterJoin(PlanNode joinNode, Criteria crit) {
        JoinType joinType = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (joinType != null) {
            if (joinType.isOuter()) {
                if (joinType.equals((Object)JoinType.JOIN_FULL_OUTER)) {
                    return true;
                }
                if (joinType.equals((Object)JoinType.JOIN_LEFT_OUTER)) {
                    Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
                    if (joinNode.getLastChild().getGroups().containsAll(groups)) {
                        return true;
                    }
                } else {
                    Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
                    if (joinNode.getFirstChild().getGroups().containsAll(groups)) {
                        return true;
                    }
                }
            }
        } else {
            Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
            if (groups.size() > 0) {
                GroupSymbol critGroup = (GroupSymbol)groups.iterator().next();
                From from = (From)joinNode.getProperty((Object)NodeConstants.Info.FROM_CLAUSE);
                if (from.isGroupOnInnerSideOfOuterJoin(critGroup)) {
                    return true;
                }
            }
        }
        return false;
    }

    boolean shouldRemoveOriginal(PlanNode critNode, PlanNode destinationNode) {
        if (critNode.getParent().getType() == 7) {
            return true;
        }
        GroupSymbol critGroup = null;
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
        if (groups.size() == 1) {
            critGroup = (GroupSymbol)groups.iterator().next();
        }
        for (PlanNode currentNode = destinationNode; currentNode != critNode; currentNode = currentNode.getParent()) {
            int nodeType = currentNode.getType();
            if (nodeType != 7) continue;
            JoinType joinType = (JoinType)currentNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
            if (joinType != null && joinType.isOuter()) {
                return false;
            }
            From fromClause = (From)currentNode.getProperty((Object)NodeConstants.Info.FROM_CLAUSE);
            if (fromClause == null) continue;
            LinkedList<FromClause> clauses = new LinkedList<FromClause>(fromClause.getClauses());
            while (clauses.size() > 0) {
                Object clause = clauses.removeFirst();
                if (!(clause instanceof JoinPredicate)) continue;
                JoinPredicate jp = (JoinPredicate)clause;
                if (jp.getJoinType().isOuter()) {
                    if (critGroup == null || jp.getJoinType().equals((Object)JoinType.JOIN_FULL_OUTER)) {
                        return false;
                    }
                    if (jp.getJoinType().equals((Object)JoinType.JOIN_LEFT_OUTER) && !GroupCollectorVisitor.getGroups((LanguageObject)jp.getLeftClause(), (boolean)true).contains(critGroup)) {
                        return false;
                    }
                    if (jp.getJoinType().equals((Object)JoinType.JOIN_RIGHT_OUTER) && !GroupCollectorVisitor.getGroups((LanguageObject)jp.getRightClause(), (boolean)true).contains(critGroup)) {
                        return false;
                    }
                }
                clauses.add(jp.getLeftClause());
                clauses.add(jp.getRightClause());
            }
        }
        return true;
    }

    void moveNodeWithinFrame(PlanNode critNode, PlanNode destinationParent, PlanNode destinationChild, boolean shouldRemove) {
        Assertion.isNotNull((Object)critNode.getParent());
        PlanNode newNode = critNode;
        if (shouldRemove) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
        } else {
            newNode = this.copyNode(critNode);
        }
        RulePushSelectCriteria.replaceWithPlannedQuery(newNode);
        NodeEditor.insertNode(destinationParent, destinationChild, newNode);
    }

    static void replaceWithPlannedQuery(PlanNode critNode) {
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Iterator valueIteratorProviders = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit).iterator();
        if (valueIteratorProviders.hasNext()) {
            SubqueryContainer container = (SubqueryContainer)valueIteratorProviders.next();
            RelationalPlan subqueryPlan = (RelationalPlan)((Collection)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS)).iterator().next();
            RelationalNode root = subqueryPlan.getRootNode();
            AccessNode child = (AccessNode)root.getChildren()[0];
            container.setCommand(child.getCommand());
        }
    }

    static void recontextCorrelatedReferenceGroups(PlanNode critNode, QueryMetadataInterface metadata) throws QueryMetadataException, QueryPlannerException, MetaMatrixComponentException {
        From upperFrom;
        SubqueryContainer container;
        Iterator valueIteratorProviders;
        List refs = (List)critNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs == null || refs.size() == 0) {
            return;
        }
        if (critNode.getType() == 13) {
            PlanNode placeholderNode = critNode;
            while (placeholderNode.getParent() != null && (placeholderNode = placeholderNode.getParent()).getType() != 3) {
                if (placeholderNode.getType() == 13) continue;
                return;
            }
        }
        ArrayList refGroups = new ArrayList(refs.size());
        Iterator refIter = refs.iterator();
        while (refIter.hasNext()) {
            Reference ref = (Reference)refIter.next();
            Expression expr = ref.getExpression();
            GroupsUsedByElementsVisitor.getGroups((LanguageObject)expr, refGroups);
        }
        PlanNode currentNode = critNode;
        while (currentNode.getParent() != null && currentNode.getParent().getType() != 19) {
            currentNode = currentNode.getParent();
        }
        ArrayList frames = new ArrayList();
        FrameUtil.findQueryFrames(currentNode, null, frames);
        QueryFrame frame = null;
        Iterator i = frames.iterator();
        while (i.hasNext() && !(frame = (QueryFrame)i.next()).containsNode(critNode)) {
        }
        Assertion.isNotNull(frame);
        Collection subqueryGroups = null;
        if (critNode.getType() == 13) {
            Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            valueIteratorProviders = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit).iterator();
            if (valueIteratorProviders.hasNext()) {
                container = (SubqueryContainer)valueIteratorProviders.next();
                subqueryGroups = GroupCollectorVisitor.getGroups((LanguageObject)container.getCommand(), (boolean)true);
            }
        } else if (critNode.getType() == 7 && (valueIteratorProviders = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)(upperFrom = (From)critNode.getProperty((Object)NodeConstants.Info.FROM_CLAUSE))).iterator()).hasNext()) {
            container = (SubqueryContainer)valueIteratorProviders.next();
            subqueryGroups = GroupCollectorVisitor.getGroups((LanguageObject)container.getCommand(), (boolean)true);
        }
        List overlapGroups = FrameUtil.getOverlappingGroups(null, new HashSet(refGroups), new HashSet(subqueryGroups));
        if (overlapGroups != null && overlapGroups.size() > 0) {
            HashSet allGroups = new HashSet();
            allGroups.addAll(refGroups);
            allGroups.addAll(subqueryGroups);
            allGroups.addAll(frame.getSourceGroups());
            Set allNames = FrameUtil.getNamesFromSymbols(allGroups);
            Iterator overlapIter = overlapGroups.iterator();
            while (overlapIter.hasNext()) {
                GroupSymbol overlapGroup = (GroupSymbol)overlapIter.next();
                GroupSymbol newSymbol = FrameUtil.recontextSymbol(overlapGroup, allNames);
                Map symbolMap = FrameUtil.buildSymbolMap(overlapGroup, newSymbol, metadata);
                PlanNode startNode = null;
                List bottomNodes = frame.getBottomNodes();
                Iterator iter = bottomNodes.iterator();
                while (iter.hasNext()) {
                    PlanNode sourceNode = (PlanNode)iter.next();
                    if (!overlapGroup.equals(sourceNode.getGroups().iterator().next())) continue;
                    startNode = sourceNode;
                }
                FrameUtil.convertFrame(frame, startNode, overlapGroup, newSymbol, symbolMap, metadata);
                refIter = refs.iterator();
                while (refIter.hasNext()) {
                    Reference ref = (Reference)refIter.next();
                    Expression expr = ref.getExpression();
                    ref.setExpression(FrameUtil.convertExpression(expr, symbolMap));
                }
            }
        }
    }

    boolean pushAcrossFrame(PlanNode plan, PlanNode critNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        Iterator groupIter = critNode.getGroups().iterator();
        PlanNode sourceNode = this.findSourceNode(critNode, (GroupSymbol)groupIter.next());
        if (this.atSourceBoundary(critNode, sourceNode, metadata) && this.canCrossSource(critNode, sourceNode, metadata) && this.canConvertSymbols(critNode, sourceNode)) {
            this.moveNodeAcrossFrame(critNode, sourceNode);
            return true;
        }
        return false;
    }

    boolean atSourceBoundary(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata) {
        if (sourceNode == null) {
            return false;
        }
        if (sourceNode.getParent() == critNode) {
            return true;
        }
        for (PlanNode currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 13) continue;
            return false;
        }
        return true;
    }

    boolean canCrossSource(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata) {
        if (sourceNode.getChildCount() == 0) {
            return false;
        }
        PlanNode projectNode = sourceNode.getFirstChild();
        if (projectNode.getType() == 11) {
            if (projectNode.getChildCount() > 0) {
                Command command;
                PlanNode procSourceNode;
                PlanNode accessNode = projectNode.getFirstChild();
                if (accessNode.getType() == 3 && accessNode.getChildCount() > 0 && (procSourceNode = accessNode.getFirstChild()).getType() == 19 && (command = (Command)procSourceNode.getProperty((Object)NodeConstants.Info.VIRTUAL_COMMAND)) instanceof StoredProcedure) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    boolean canConvertSymbols(PlanNode critNode, PlanNode sourceNode) {
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        return this.canConvertSymbols(crit, symbolMap);
    }

    boolean canConvertSymbols(Criteria crit, Map symbolMap) {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol element = (SingleElementSymbol)iter.next();
            Expression converted = (Expression)symbolMap.get(element);
            if (converted != null && !(converted instanceof AggregateSymbol)) continue;
            return false;
        }
        Iterator symbolIterator = symbolMap.values().iterator();
        while (symbolIterator.hasNext()) {
            Expression symbol = (Expression)symbolIterator.next();
            Collection scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)symbol);
            if (scalarSubqueries.isEmpty()) continue;
            return false;
        }
        return true;
    }

    void moveNodeAcrossFrame(PlanNode critNode, PlanNode sourceNode) throws QueryPlannerException {
        Assertion.isNotNull((Object)critNode.getParent());
        critNode.setProperty((Object)NodeConstants.Info.IS_PHANTOM, (Object)Boolean.TRUE);
        PlanNode copyNode = this.copyNode(critNode);
        copyNode.setProperty((Object)NodeConstants.Info.UNMAPPED_CRITERIA, critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA));
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        this.convertSelectNode(copyNode, symbolMap);
        PlanNode currentNode = sourceNode.getLastChild();
        PlanNode projectNode = null;
        boolean done = false;
        while (!done) {
            switch (currentNode.getType()) {
                case 11: {
                    projectNode = currentNode;
                    done = true;
                    break;
                }
                case 5: 
                case 17: {
                    break;
                }
                case 29: {
                    done = true;
                    break;
                }
                default: {
                    done = true;
                }
            }
            if (done) continue;
            currentNode = currentNode.getLastChild();
        }
        if (projectNode != null) {
            NodeEditor.insertNode(projectNode, projectNode.getLastChild(), copyNode);
        } else {
            NodeEditor.insertNode(sourceNode, sourceNode.getLastChild(), copyNode);
        }
    }

    PlanNode copyNode(PlanNode critNode) {
        Object depCrits;
        Object correlatedReferences;
        Object subqueryValueProviders;
        PlanNode copyNode = NodeFactory.getNewNode((int)13);
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        copyNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)copyCrit);
        copyNode.setProperty((Object)NodeConstants.Info.COPIED, critNode.getProperty((Object)NodeConstants.Info.COPIED));
        Object subqueryPlans = critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        if (subqueryPlans != null) {
            copyNode.setProperty((Object)NodeConstants.Info.SUBQUERY_PLANS, subqueryPlans);
        }
        if ((subqueryValueProviders = critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS)) != null) {
            copyNode.setProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, subqueryValueProviders);
        }
        if ((correlatedReferences = critNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES)) != null) {
            copyNode.setProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
        }
        if ((depCrits = critNode.getProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS)) != null) {
            copyNode.setProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS, depCrits);
        }
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)copyCrit, (boolean)true);
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            copyNode.addGroup(element.getGroupSymbol());
        }
        return copyNode;
    }

    void convertSelectNode(PlanNode selectNode, Map symbolMap) throws QueryPlannerException {
        Criteria crit = (Criteria)selectNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        crit = FrameUtil.convertCriteria(crit, symbolMap);
        selectNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)crit);
        selectNode.getGroups().clear();
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ElementSymbol element = (ElementSymbol)iter.next();
            selectNode.addGroup(element.getGroupSymbol());
        }
    }

    boolean pushAcrossUnion(PlanNode plan, PlanNode critNode, Collection deadNodes, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode unionNode = this.findCloseUnion(critNode);
        if (unionNode != null) {
            return this.moveNodeAcrossUnion(critNode, unionNode, deadNodes, metadata);
        }
        return false;
    }

    PlanNode findCloseUnion(PlanNode critNode) {
        PlanNode unionNode = null;
        PlanNode currentNode = critNode.getFirstChild();
        while (true) {
            int nodeType;
            if ((nodeType = currentNode.getType()) == 29 && currentNode.getProperty((Object)NodeConstants.Info.SET_OPERATION).equals(new Integer(0))) {
                unionNode = currentNode;
                break;
            }
            if (nodeType != 13 || currentNode.getChildCount() != 1) break;
            currentNode = currentNode.getFirstChild();
        }
        return unionNode;
    }

    boolean moveNodeAcrossUnion(PlanNode critNode, PlanNode unionNode, Collection deadNodes, QueryMetadataInterface metadata) throws QueryPlannerException {
        List firstProjectCols;
        PlanNode sourceNode = unionNode.getParent();
        while (sourceNode.getType() != 19) {
            sourceNode = sourceNode.getParent();
        }
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        LinkedList unionChildren = new LinkedList();
        this.collectUnionChildren(unionNode, unionChildren);
        int movedCount = 0;
        Iterator childIter = unionChildren.iterator();
        PlanNode firstChild = (PlanNode)childIter.next();
        GroupSymbol sourceGroup = (GroupSymbol)sourceNode.getGroups().iterator().next();
        if (this.moveCritThroughUnion(critNode, firstChild, null, symbolMap, sourceGroup, metadata)) {
            ++movedCount;
        }
        if ((firstProjectCols = (List)firstChild.getProperty((Object)NodeConstants.Info.PROJECT_COLS)) == null) {
            PlanNode firstBranchNode = firstChild;
            while (firstProjectCols == null) {
                firstBranchNode = firstBranchNode.getFirstChild();
                firstProjectCols = (List)firstBranchNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
            }
        }
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            if (!this.moveCritThroughUnion(critNode, childNode, firstProjectCols, symbolMap, sourceGroup, metadata)) continue;
            ++movedCount;
        }
        if (movedCount == unionChildren.size()) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
            return true;
        }
        for (PlanNode parentCritNode = critNode.getParent(); parentCritNode != null; parentCritNode = parentCritNode.getParent()) {
            Criteria parentCriteria;
            Criteria unmappedCriteria;
            if (parentCritNode.getType() != 13 || !Boolean.TRUE.equals(parentCritNode.getProperty((Object)NodeConstants.Info.IS_PHANTOM)) || (unmappedCriteria = (Criteria)critNode.getProperty((Object)NodeConstants.Info.UNMAPPED_CRITERIA)) != (parentCriteria = (Criteria)parentCritNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA))) continue;
            critNode.setProperty((Object)NodeConstants.Info.IS_PHANTOM, (Object)Boolean.TRUE);
            parentCritNode.removeProperty((Object)NodeConstants.Info.IS_PHANTOM);
            deadNodes.add(parentCritNode);
            break;
        }
        return false;
    }

    void collectUnionChildren(PlanNode unionNode, LinkedList unionChildren) {
        if (unionNode.getFirstChild().getType() == 29) {
            this.collectUnionChildren(unionNode.getFirstChild(), unionChildren);
        } else {
            unionChildren.add(unionNode.getFirstChild());
        }
        unionChildren.add(unionNode.getLastChild());
    }

    boolean moveCritThroughUnion(PlanNode critNode, PlanNode subUnionRoot, List firstProjectSymbols, Map sourceMap, GroupSymbol sourceGroup, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(subUnionRoot, 11);
        if (projectNode.getChildCount() == 0) {
            return false;
        }
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.UNMAPPED_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        PlanNode newCritNode = NodeFactory.getNewNode((int)13);
        Map symbolMap = null;
        if (firstProjectSymbols == null) {
            symbolMap = sourceMap;
        } else {
            ArrayList<ElementSymbol> virtualElements = new ArrayList<ElementSymbol>(firstProjectSymbols.size());
            String groupName = sourceGroup.getName();
            Iterator firstProjIter = firstProjectSymbols.iterator();
            while (firstProjIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)firstProjIter.next();
                String symbolShortName = symbol.getShortName();
                ElementSymbol element = new ElementSymbol(groupName + "." + symbolShortName);
                element.setGroupSymbol(sourceGroup);
                element.setType(symbol.getType());
                virtualElements.add(element);
            }
            symbolMap = this.createSymbolMap((List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS), virtualElements, metadata);
        }
        if (!this.canConvertSymbols(copyCrit, symbolMap)) {
            return false;
        }
        copyCrit = FrameUtil.convertCriteria(copyCrit, symbolMap);
        newCritNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)copyCrit);
        Boolean hasDepCrits = (Boolean)critNode.getProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS);
        if (hasDepCrits != null) {
            newCritNode.setProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS, (Object)hasDepCrits);
        }
        newCritNode.getGroups().clear();
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)copyCrit, (boolean)true);
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            newCritNode.addGroup(element.getGroupSymbol());
        }
        NodeEditor.insertNode(projectNode, projectNode.getFirstChild(), newCritNode);
        return true;
    }

    Map createSymbolMap(List laterSymbols, List virtualElements, QueryMetadataInterface metadata) {
        HashMap<ElementSymbol, Object> symbolMap = new HashMap<ElementSymbol, Object>();
        for (int i = 0; i < virtualElements.size(); ++i) {
            ElementSymbol virtualElement = (ElementSymbol)virtualElements.get(i);
            SingleElementSymbol laterSymbol = (SingleElementSymbol)laterSymbols.get(i);
            if (laterSymbol instanceof AliasSymbol) {
                laterSymbol = ((AliasSymbol)laterSymbol).getSymbol();
            }
            if (laterSymbol instanceof ExpressionSymbol && !(laterSymbol instanceof AggregateSymbol)) {
                symbolMap.put(virtualElement, ((ExpressionSymbol)laterSymbol).getExpression());
                continue;
            }
            symbolMap.put(virtualElement, laterSymbol);
        }
        return symbolMap;
    }

    boolean pushAcrossGroupBy(PlanNode plan, PlanNode critNode) {
        PlanNode groupNode = this.findCloseGroupBy(critNode);
        if (groupNode != null && this.canMoveAcrossGroup(critNode, groupNode)) {
            this.moveNodeAcrossGroupBy(critNode, groupNode);
            return true;
        }
        return false;
    }

    PlanNode findCloseGroupBy(PlanNode critNode) {
        PlanNode groupNode = null;
        PlanNode currentNode = critNode.getFirstChild();
        while (true) {
            int nodeType;
            if ((nodeType = currentNode.getType()) == 23) {
                groupNode = currentNode;
                break;
            }
            if (nodeType != 13 || currentNode.getChildCount() != 1) break;
            currentNode = currentNode.getFirstChild();
        }
        return groupNode;
    }

    boolean canMoveAcrossGroup(PlanNode critNode, PlanNode groupNode) {
        List groupElements = (List)groupNode.getProperty((Object)NodeConstants.Info.GROUP_COLS);
        if (groupElements != null) {
            Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            Set critElements = (Set)ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
            return groupElements.containsAll(critElements);
        }
        return false;
    }

    void moveNodeAcrossGroupBy(PlanNode critNode, PlanNode groupNode) {
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
        NodeEditor.insertNode(groupNode, groupNode.getLastChild(), critNode);
    }

    public String toString() {
        return "PushSelectCriteria";
    }
}

