/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class RulePushJoinCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        LinkedList critNodes = new LinkedList();
        this.findJoinCriteria(plan, critNodes);
        if (critNodes.size() == 0) {
            return plan;
        }
        Iterator nodeIter = critNodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode critNode = (PlanNode)nodeIter.next();
            PlanNode joinNode = this.findJoinNode(critNode, critNode.getGroups());
            boolean updated = false;
            if (joinNode != null) {
                updated = this.updateJoinCriteria(joinNode, (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA));
            }
            if (!updated) continue;
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
        }
        return plan;
    }

    void findJoinCriteria(PlanNode root, List foundNodes) throws QueryPlannerException, MetaMatrixComponentException {
        Criteria crit;
        if (root.getType() == 13 && root.getGroups().size() == 2 && GroupsUsedByElementsVisitor.getGroups((LanguageObject)(crit = (Criteria)root.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA))).size() == 2) {
            foundNodes.add(root);
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findJoinCriteria(child, foundNodes);
            }
        }
    }

    PlanNode findJoinNode(PlanNode root, Set groups) {
        if (root.getType() == 7 && root.getGroups().containsAll(groups)) {
            return root;
        }
        List children = root.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            PlanNode found = this.findJoinNode(child, groups);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    boolean updateJoinCriteria(PlanNode joinNode, Criteria newCrit) {
        LinkedList<Criteria> joinCrit;
        From from = (From)joinNode.getProperty((Object)NodeConstants.Info.FROM_CLAUSE);
        if (from != null) {
            Iterator i = GroupsUsedByElementsVisitor.getGroups((LanguageObject)newCrit).iterator();
            while (i.hasNext()) {
                GroupSymbol critGroup = (GroupSymbol)i.next();
                if (!from.isGroupOnInnerSideOfOuterJoin(critGroup)) continue;
                return false;
            }
        }
        if ((joinCrit = (LinkedList<Criteria>)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA)) == null) {
            joinCrit = new LinkedList<Criteria>();
        }
        joinCrit.add(newCrit);
        joinNode.setProperty((Object)NodeConstants.Info.JOIN_CRITERIA, joinCrit);
        return true;
    }

    public String toString() {
        return "PushJoinCriteria";
    }
}

