/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RuleCollapseUnions
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode rootNode = plan;
        boolean collapsedNode = true;
        block0: while (collapsedNode) {
            collapsedNode = false;
            List nodes = NodeEditor.findAllNodes(rootNode, 29);
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                PlanNode unionNode = (PlanNode)iter.next();
                List accessNodes = this.canCollapseUnion(unionNode, metadata, capFinder);
                if (accessNodes == null) continue;
                rootNode = this.collapseUnion(unionNode, accessNodes, rootNode, metadata, capFinder);
                collapsedNode = true;
                continue block0;
            }
        }
        return rootNode;
    }

    private List canCollapseUnion(PlanNode unionNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        List childNodes = unionNode.getChildren();
        ArrayList<PlanNode> accessNodes = new ArrayList<PlanNode>(childNodes.size());
        Iterator childIter = childNodes.iterator();
        while (childIter.hasNext()) {
            PlanNode projectNode = null;
            PlanNode accessNode = null;
            PlanNode childNode = (PlanNode)childIter.next();
            if (childNode.getType() == 11) {
                projectNode = childNode;
                if (projectNode.getChildCount() > 0 && projectNode.getFirstChild().getType() == 3) {
                    accessNode = projectNode.getFirstChild();
                }
            } else if (childNode.getType() == 3) {
                accessNode = childNode;
            }
            if (accessNode == null || !(accessNode.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST) instanceof QueryCommand)) {
                return null;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            if (this.checkProjectColumnDifferences(projectNode, accessNode)) {
                return null;
            }
            if (modelID == null) {
                modelID = accessModelID;
                if (!CapabilitiesUtil.supportsUnion(accessModelID, metadata, capFinder)) {
                    return null;
                }
            } else if (!modelID.equals(accessModelID)) {
                return null;
            }
            accessNodes.add(accessNode);
        }
        return accessNodes;
    }

    private boolean checkProjectColumnDifferences(PlanNode projectNode, PlanNode accessNode) {
        if (projectNode == null) {
            return false;
        }
        List projectedColumns = (List)projectNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
        List accessColumns = (List)accessNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
        return projectedColumns.size() != accessColumns.size();
    }

    private PlanNode collapseUnion(PlanNode unionNode, List accessNodes, PlanNode rootNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        boolean unionAll = (Boolean)unionNode.getProperty((Object)NodeConstants.Info.USE_ALL);
        PlanNode megaAccess = NodeFactory.getNewNode((int)3);
        Object modelID = null;
        SetQuery unionCommand = new SetQuery();
        boolean first = true;
        Iterator accessNodeIter = accessNodes.iterator();
        while (accessNodeIter.hasNext()) {
            PlanNode accessNode = (PlanNode)accessNodeIter.next();
            QueryCommand command = (QueryCommand)accessNode.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
            if (first) {
                modelID = accessNode.getProperty((Object)NodeConstants.Info.MODEL_ID);
                if (command instanceof SetQuery && ((SetQuery)command).getOrderBy() == null) {
                    unionCommand = (SetQuery)command;
                } else {
                    unionCommand.addQuery(command, unionAll);
                }
                this.correctPushedAliasedLiterals(accessNode, true);
                first = false;
            } else {
                this.correctPushedAliasedLiterals(accessNode, false);
                unionCommand.addQuery(command, unionAll);
            }
            megaAccess.addGroups((Collection)accessNode.getGroups());
        }
        megaAccess.setProperty((Object)NodeConstants.Info.MODEL_ID, modelID);
        megaAccess.setProperty((Object)NodeConstants.Info.ATOMIC_REQUEST, (Object)unionCommand);
        PlanNode replaceNode = unionNode;
        PlanNode unionParent = unionNode.getParent();
        if (unionParent != null && unionParent.getType() == 17 && CapabilitiesUtil.supportsUnionOrderBy(modelID, metadata, capFinder)) {
            List params = (List)unionParent.getProperty((Object)NodeConstants.Info.SORT_ORDER);
            List types = (List)unionParent.getProperty((Object)NodeConstants.Info.ORDER_TYPES);
            OrderBy orderBy = new OrderBy(params, types);
            unionCommand.setOrderBy(orderBy);
            replaceNode = unionParent;
        }
        megaAccess.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, replaceNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
        megaAccess.setProperty((Object)NodeConstants.Info.TOP_COLS, replaceNode.getProperty((Object)NodeConstants.Info.TOP_COLS));
        return this.replaceOldStructureWithNewAccessNode(rootNode, replaceNode, megaAccess);
    }

    private void correctPushedAliasedLiterals(PlanNode accessNode, boolean preserveAliases) {
        PlanNode projectNode = accessNode.getParent();
        if (projectNode == null || projectNode.getType() != 11) {
            return;
        }
        Command command = (Command)accessNode.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
        if (!(command instanceof Query)) {
            return;
        }
        Query query = (Query)command;
        Select select = query.getSelect();
        for (PlanNode parent = projectNode.getParent(); parent != null && parent.getType() != 19; parent = parent.getParent()) {
        }
        Select newSelect = new Select();
        newSelect.setDistinct(select.isDistinct());
        List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        Iterator iter = projectCols.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SingleElementSymbol projSymbol = (SingleElementSymbol)iter.next();
            if (!preserveAliases && projSymbol instanceof AliasSymbol) {
                projSymbol = ((AliasSymbol)projSymbol).getSymbol();
            }
            newSelect.addSymbol((SelectSymbol)projSymbol);
            ++i;
        }
        query.setSelect(newSelect);
    }

    private PlanNode replaceOldStructureWithNewAccessNode(PlanNode oldRoot, PlanNode structureRoot, PlanNode newAccess) {
        if (structureRoot.getParent() == null) {
            return newAccess;
        }
        ArrayList children = new ArrayList(structureRoot.getChildren());
        for (int i = 0; i < children.size(); ++i) {
            structureRoot.removeChild((PlanNode)children.get(i));
        }
        NodeEditor.replaceNode(structureRoot, newAccess);
        return oldRoot;
    }

    public String toString() {
        return "CollapseUnions";
    }
}

