/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleChooseAccessPattern
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) {
        ArrayList accessNodes = new ArrayList();
        this.findAccessNodesWithAccessPatterns(plan, accessNodes);
        Iterator nodeIter = accessNodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode accessNode = (PlanNode)nodeIter.next();
            this.chooseAccessPattern(accessNode, metadata);
        }
        return plan;
    }

    void findAccessNodesWithAccessPatterns(PlanNode node, List accessNodes) {
        if (node.getType() == 3 && node.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            accessNodes.add(node);
        }
        if (node.getChildCount() > 0) {
            List children = node.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findAccessNodesWithAccessPatterns(child, accessNodes);
            }
        }
    }

    void chooseAccessPattern(PlanNode accessNode, QueryMetadataInterface metadata) {
        Collection accessPatterns = (Collection)accessNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
        Map elementIDsToSelectNodes = this.mapElementIDsToSelectNodes(accessNode);
        if (elementIDsToSelectNodes.isEmpty()) {
            return;
        }
        HashSet conjunctElementsCache = new HashSet();
        HashSet<Collection> conjunctCache = new HashSet<Collection>();
        Iterator accessPatternIter = accessPatterns.iterator();
        Set entrySet = elementIDsToSelectNodes.entrySet();
        Iterator entries = null;
        while (accessPatternIter.hasNext()) {
            List accessPatternElements = (List)accessPatternIter.next();
            entries = entrySet.iterator();
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                Collection conjunctElements = (Collection)entry.getKey();
                if (!accessPatternElements.containsAll(conjunctElements)) continue;
                conjunctElementsCache.addAll(conjunctElements);
                conjunctCache.add(conjunctElements);
            }
            if (conjunctElementsCache.containsAll(accessPatternElements)) {
                Iterator conjuncts = conjunctCache.iterator();
                while (conjuncts.hasNext()) {
                    elementIDsToSelectNodes.remove(conjuncts.next());
                }
                accessNode.setProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED, (Object)accessPatternElements);
                break;
            }
            conjunctElementsCache.clear();
            conjunctCache.clear();
        }
        if (!accessNode.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
            accessPatternIter = accessPatterns.iterator();
            entrySet = elementIDsToSelectNodes.entrySet();
            entries = null;
            while (accessPatternIter.hasNext()) {
                boolean foundPartialMatch = false;
                List accessPatternElements = (List)accessPatternIter.next();
                entries = entrySet.iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    Collection conjunctElements = (Collection)entry.getKey();
                    if (!accessPatternElements.containsAll(conjunctElements)) continue;
                    conjunctElementsCache.addAll(conjunctElements);
                    conjunctCache.add(conjunctElements);
                    foundPartialMatch = true;
                }
                if (foundPartialMatch) {
                    Iterator conjuncts = conjunctCache.iterator();
                    while (conjuncts.hasNext()) {
                        elementIDsToSelectNodes.remove(conjuncts.next());
                    }
                    break;
                }
                conjunctElementsCache.clear();
                conjunctCache.clear();
            }
        }
        entries = entrySet.iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            PlanNode selectNode = (PlanNode)entry.getValue();
            this.moveNodeWithinFrame(selectNode, accessNode);
        }
    }

    Map mapElementIDsToSelectNodes(PlanNode accessNode) {
        HashMap<Collection, PlanNode> elementIDsToSelectNodes = new HashMap<Collection, PlanNode>();
        boolean done = false;
        PlanNode node = accessNode;
        while (!done) {
            if ((node = (PlanNode)node.getChildren().iterator().next()).getType() == 13) {
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                elementIDsToSelectNodes.put(this.getCritElementIDs(crit), node);
                continue;
            }
            done = true;
        }
        return elementIDsToSelectNodes;
    }

    Collection getCritElementIDs(Criteria crit) {
        boolean REMOVE_DUPLICATES = true;
        Collection critElements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        ArrayList<Object> critElementIDs = new ArrayList<Object>(critElements.size());
        Iterator elemIter = critElements.iterator();
        while (elemIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elemIter.next();
            critElementIDs.add(element.getMetadataID());
        }
        return critElementIDs;
    }

    void moveNodeWithinFrame(PlanNode selectNode, PlanNode accessNode) {
        PlanNode targetNode = accessNode;
        boolean done = false;
        while (!done) {
            if (targetNode.getParent() != null && targetNode.getParent().getType() == 7) {
                targetNode = targetNode.getParent();
                continue;
            }
            done = true;
        }
        NodeEditor.removeChildNode(selectNode.getParent(), selectNode);
        NodeEditor.insertNode(targetNode.getParent(), targetNode, selectNode);
    }

    public String toString() {
        return "ChooseAccessPattern";
    }
}

