/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerID;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleAssignOutputElements;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.DependentAccessNode;
import com.metamatrix.query.processor.relational.DependentFeederNode;
import com.metamatrix.query.processor.relational.DependentProjectNode;
import com.metamatrix.query.processor.relational.DependentSelectNode;
import com.metamatrix.query.processor.relational.DependentValueSource;
import com.metamatrix.query.processor.relational.DependentWaitNode;
import com.metamatrix.query.processor.relational.DupRemoveNode;
import com.metamatrix.query.processor.relational.GroupingNode;
import com.metamatrix.query.processor.relational.HashJoinStrategy;
import com.metamatrix.query.processor.relational.JoinNode;
import com.metamatrix.query.processor.relational.JoinStrategy;
import com.metamatrix.query.processor.relational.LimitNode;
import com.metamatrix.query.processor.relational.MergeJoinStrategy;
import com.metamatrix.query.processor.relational.NestedLoopJoinStrategy;
import com.metamatrix.query.processor.relational.NullNode;
import com.metamatrix.query.processor.relational.OffsetNode;
import com.metamatrix.query.processor.relational.PlanExecutionNode;
import com.metamatrix.query.processor.relational.ProjectIntoNode;
import com.metamatrix.query.processor.relational.ProjectNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.processor.relational.SelectNode;
import com.metamatrix.query.processor.relational.SortNode;
import com.metamatrix.query.processor.relational.UnionAllNode;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.DependentSetCriteriaCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PlanToProcessConverter {
    private static final boolean LEFT = false;
    private static final boolean RIGHT = true;

    public static ProcessorPlan convert(PlanNode planNode, QueryMetadataInterface metadata, IDGenerator idGenerator, AnalysisRecord analysisRecord, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n============================================================================");
            analysisRecord.println("CONVERTING PLAN TREE TO PROCESS TREE");
        }
        RelationalNode processNode = PlanToProcessConverter.convertPlan(planNode, null, idGenerator, metadata, capFinder);
        if (debug) {
            analysisRecord.println("\nPROCESS PLAN = \n" + processNode);
            analysisRecord.println("============================================================================");
        }
        RelationalPlan processPlan = new RelationalPlan(processNode);
        return processPlan;
    }

    private static RelationalNode convertPlan(PlanNode planNode, RelationalNode parent, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        RelationalNode convertedNode = PlanToProcessConverter.convertNode(planNode, idGenerator, metadata, capFinder);
        RelationalNode nextParent = null;
        if (convertedNode != null) {
            if (parent != null) {
                parent.addChild(convertedNode);
            }
            nextParent = convertedNode;
            while (nextParent.getChildren()[0] != null) {
                nextParent = nextParent.getChildren()[0];
            }
        } else {
            convertedNode = parent;
            nextParent = parent;
        }
        Iterator childIter = planNode.getChildren().iterator();
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            PlanToProcessConverter.convertPlan(childNode, nextParent, idGenerator, metadata, capFinder);
        }
        return convertedNode;
    }

    private static int getID(IDGenerator idGenerator) {
        IntegerIDFactory intFactory = (IntegerIDFactory)idGenerator.getDefaultFactory();
        return ((IntegerID)intFactory.create()).getValue();
    }

    private static RelationalNode convertNode(PlanNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        Object processNode = null;
        Command possiblyDependentObject = null;
        switch (node.getType()) {
            case 11: {
                GroupSymbol intoGroup = (GroupSymbol)node.getProperty((Object)NodeConstants.Info.INTO_GROUP);
                if (intoGroup != null) {
                    ProjectIntoNode pinode = new ProjectIntoNode(PlanToProcessConverter.getID(idGenerator));
                    pinode.setIntoGroup(intoGroup);
                    try {
                        ArrayList allIntoElements = ResolverUtil.resolveElementsInGroup((GroupSymbol)intoGroup, (QueryMetadataInterface)metadata);
                        ArrayList actualIntoElements = null;
                        if (!intoGroup.isTempGroupSymbol()) {
                            actualIntoElements = allIntoElements;
                        } else {
                            PlanNode lowerProject = node.getFirstChild();
                            while (lowerProject.getType() != 11) {
                                lowerProject = lowerProject.getFirstChild();
                            }
                            actualIntoElements = new ArrayList(allIntoElements.size());
                            List projectedElements = (List)lowerProject.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                            Map symbolMap = (Map)node.getLastChild().getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                            List topSymbols = RuleAssignOutputElements.reverseSymbolLookup(projectedElements, symbolMap);
                            Iterator projIter = topSymbols.iterator();
                            while (projIter.hasNext()) {
                                SingleElementSymbol projSymbol = (SingleElementSymbol)projIter.next();
                                ElementSymbol matchSymbol = new ElementSymbol(intoGroup.getName() + "." + projSymbol.getShortName());
                                int index = allIntoElements.indexOf(matchSymbol);
                                actualIntoElements.add(allIntoElements.get(index));
                            }
                        }
                        pinode.setIntoElements((List)actualIntoElements);
                        Object groupID = intoGroup.getMetadataID();
                        Object modelID = metadata.getModelID(groupID);
                        String modelName = metadata.getFullName(modelID);
                        pinode.setModelName(modelName);
                        if (!metadata.isTemporaryGroup(groupID) && !metadata.isVirtualGroup(groupID)) {
                            SourceCapabilities caps = capFinder.findCapabilities(modelName);
                            pinode.setDoBatching(caps.supportsCapability("UPDATE.BATCHED"));
                        }
                    }
                    catch (QueryResolverException e) {
                        throw new MetaMatrixComponentException((Throwable)e);
                    }
                    catch (QueryMetadataException e) {
                        throw new MetaMatrixComponentException((Throwable)e);
                    }
                    processNode = pinode;
                    break;
                }
                List subqueryPlans = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
                if (subqueryPlans == null) {
                    ProjectNode pnode = new ProjectNode(PlanToProcessConverter.getID(idGenerator));
                    List symbols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                    pnode.setSelectSymbols(symbols);
                    processNode = pnode;
                    break;
                }
                List subqueries = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
                DependentProjectNode pnode = new DependentProjectNode(PlanToProcessConverter.getID(idGenerator));
                List symbols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                pnode.setSelectSymbols(symbols);
                pnode.setPlansAndValueProviders(subqueryPlans, subqueries);
                List correlatedReferences = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
                if (correlatedReferences != null) {
                    pnode.setCorrelatedReferences(correlatedReferences);
                }
                processNode = pnode;
                break;
            }
            case 7: {
                JoinType jtype = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                JoinStrategyType stype = (JoinStrategyType)node.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
                if (stype.equals((Object)JoinStrategyType.MERGE)) {
                    MergeJoinStrategy mjStrategy = new MergeJoinStrategy();
                    JoinNode mjnode = new JoinNode(PlanToProcessConverter.getID(idGenerator));
                    mjnode.setJoinStrategy((JoinStrategy)mjStrategy);
                    mjnode.setJoinType(jtype);
                    List leftExpressions = (List)node.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS);
                    List rightExpressions = (List)node.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS);
                    mjnode.setJoinExpressions(leftExpressions, rightExpressions);
                    PlanToProcessConverter.buildSortedJoinInputs(node, metadata, mjnode);
                    processNode = mjnode;
                    break;
                }
                if (stype != null && stype.equals((Object)JoinStrategyType.HASH)) {
                    HashJoinStrategy hjStrategy = new HashJoinStrategy();
                    JoinNode hjnode = new JoinNode(PlanToProcessConverter.getID(idGenerator));
                    hjnode.setJoinStrategy((JoinStrategy)hjStrategy);
                    hjnode.setJoinType(jtype);
                    CompareCriteria crit = (CompareCriteria)PlanToProcessConverter.getJoinCriteria(node);
                    ElementSymbol e1 = (ElementSymbol)crit.getLeftExpression();
                    ElementSymbol e2 = (ElementSymbol)crit.getRightExpression();
                    ArrayList<ElementSymbol> leftExpr = new ArrayList<ElementSymbol>();
                    ArrayList<ElementSymbol> rightExpr = new ArrayList<ElementSymbol>();
                    List independentSymbols = (List)node.getProperty((Object)NodeConstants.Info.INDEPENDENT_ELEMENT);
                    ElementSymbol independentSymbol = (ElementSymbol)independentSymbols.iterator().next();
                    if (e1 == independentSymbol) {
                        leftExpr.add(e1);
                        rightExpr.add(e2);
                    } else {
                        leftExpr.add(e2);
                        rightExpr.add(e1);
                    }
                    hjnode.setJoinExpressions(leftExpr, rightExpr);
                    processNode = hjnode;
                    break;
                }
                NestedLoopJoinStrategy nljStrategy = new NestedLoopJoinStrategy();
                JoinNode jnode = new JoinNode(PlanToProcessConverter.getID(idGenerator));
                jnode.setJoinStrategy((JoinStrategy)nljStrategy);
                jnode.setJoinType(jtype);
                jnode.setJoinCriteria(PlanToProcessConverter.getJoinCriteria(node));
                processNode = jnode;
                break;
            }
            case 3: {
                ProcessorPlan plan = (ProcessorPlan)node.getProperty((Object)NodeConstants.Info.PROCESSOR_PLAN);
                if (plan != null) {
                    PlanExecutionNode peNode = new PlanExecutionNode(PlanToProcessConverter.getID(idGenerator));
                    peNode.setProcessorPlan(plan);
                    processNode = peNode;
                    break;
                }
                if (node.getProperty((Object)NodeConstants.Info.DEPENDENT_ELEMENT) != null) {
                    Collection accessPatternUsed;
                    DependentAccessNode depAccessNode = new DependentAccessNode(PlanToProcessConverter.getID(idGenerator));
                    Criteria joinCriteria = PlanToProcessConverter.getJoinCriteria(node);
                    depAccessNode.setJoinCriteria(joinCriteria);
                    Boolean allowsNoCriteria = (Boolean)node.getProperty((Object)NodeConstants.Info.ALLOWS_NO_CRITERIA);
                    if (allowsNoCriteria != null) {
                        depAccessNode.setAllowsNoCriteria(allowsNoCriteria.booleanValue());
                    }
                    if ((accessPatternUsed = (Collection)node.getProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) != null && !accessPatternUsed.isEmpty()) {
                        depAccessNode.setAccessPattern(accessPatternUsed);
                    }
                    JoinStrategyType joinStrategy = (JoinStrategyType)node.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
                    depAccessNode.setJoinStrategyType(joinStrategy);
                    List isymbols = (List)node.getProperty((Object)NodeConstants.Info.INDEPENDENT_ELEMENT);
                    List dsymbols = (List)node.getProperty((Object)NodeConstants.Info.DEPENDENT_ELEMENT);
                    depAccessNode.setEquivalentSymbols(isymbols, dsymbols);
                    depAccessNode.setIDGenerator(idGenerator);
                    processNode = depAccessNode;
                } else {
                    AccessNode anode = new AccessNode(PlanToProcessConverter.getID(idGenerator));
                    processNode = anode;
                }
                possiblyDependentObject = PlanToProcessConverter.setAccessNodeCommand((AccessNode)((Object)processNode), node, metadata);
                Object modelID = node.getProperty((Object)NodeConstants.Info.MODEL_ID);
                int maxSetSize = -1;
                if (modelID != null) {
                    try {
                        maxSetSize = CapabilitiesUtil.getMaxInCriteriaSize(modelID, metadata, capFinder);
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0006", modelID));
                    }
                }
                ((AccessNode)((Object)processNode)).setMaxSetSize(maxSetSize);
                break;
            }
            case 13: {
                List subPlans = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                if (subPlans == null) {
                    SelectNode selnode = new SelectNode(PlanToProcessConverter.getID(idGenerator));
                    selnode.setCriteria(crit);
                    processNode = selnode;
                } else {
                    List subCrits = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
                    DependentSelectNode selnode = null;
                    selnode = new DependentSelectNode(PlanToProcessConverter.getID(idGenerator));
                    selnode.setCriteria(crit);
                    selnode.setPlansAndCriteriaMapping(subPlans, subCrits);
                    List correlatedReferences = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
                    if (correlatedReferences != null) {
                        selnode.setCorrelatedReferences(correlatedReferences);
                    }
                    processNode = selnode;
                }
                possiblyDependentObject = crit;
                break;
            }
            case 17: {
                List elements = (List)node.getProperty((Object)NodeConstants.Info.SORT_ORDER);
                List sortTypes = (List)node.getProperty((Object)NodeConstants.Info.ORDER_TYPES);
                SortNode sortNode = new SortNode(PlanToProcessConverter.getID(idGenerator));
                sortNode.setSortElements(elements, sortTypes);
                processNode = sortNode;
                break;
            }
            case 5: {
                processNode = new DupRemoveNode(PlanToProcessConverter.getID(idGenerator));
                break;
            }
            case 23: {
                GroupingNode gnode = new GroupingNode(PlanToProcessConverter.getID(idGenerator));
                gnode.setGroupingElements((List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS));
                processNode = gnode;
                break;
            }
            case 19: {
                Map symbolMap = (Map)node.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                if (symbolMap != null) {
                    PlanNode child = node.getLastChild();
                    child.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, (Object)symbolMap);
                    child.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
                }
                return null;
            }
            case 29: {
                int setOp = (Integer)node.getProperty((Object)NodeConstants.Info.SET_OPERATION);
                boolean useAll = (Boolean)node.getProperty((Object)NodeConstants.Info.USE_ALL);
                if (setOp != 0) break;
                UnionAllNode unionAllNode = new UnionAllNode(PlanToProcessConverter.getID(idGenerator));
                if (useAll) {
                    processNode = unionAllNode;
                    break;
                }
                processNode = new DupRemoveNode(PlanToProcessConverter.getID(idGenerator));
                unionAllNode.setElements((List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
                processNode.addChild((RelationalNode)unionAllNode);
                break;
            }
            case 41: {
                Expression rowLimit = (Expression)node.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
                processNode = new LimitNode(PlanToProcessConverter.getID(idGenerator), rowLimit);
                break;
            }
            case 37: {
                Expression offset = (Expression)node.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
                processNode = new OffsetNode(PlanToProcessConverter.getID(idGenerator), offset);
                break;
            }
            case 31: {
                processNode = new NullNode(PlanToProcessConverter.getID(idGenerator));
                break;
            }
            default: {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0007", (Object)NodeConstants.getNodeTypeString(node.getType())));
            }
        }
        if (processNode != null) {
            DependentValueSource depValueSource;
            Boolean hasSetCrits;
            Long estimateJoinCost;
            Long estimateDepJoinCost;
            Long estimateDepAccessCardinality;
            Integer estimateNodeSetSize;
            Map symbolMap = (Map)node.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
            if (symbolMap != null) {
                processNode.setSymbolMap(symbolMap);
            }
            List cols = (List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
            processNode.setElements(cols);
            List topCols = (List)node.getProperty((Object)NodeConstants.Info.TOP_COLS);
            processNode.setTopElements(topCols);
            Integer estimateNodeCardinality = (Integer)node.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
            if (estimateNodeCardinality != null) {
                processNode.setEstimateNodeCardinality(estimateNodeCardinality);
            }
            if ((estimateNodeSetSize = (Integer)node.getProperty((Object)NodeConstants.Info.EST_SET_SIZE)) != null) {
                processNode.setEstimateNodeSetSize(estimateNodeSetSize);
            }
            if ((estimateDepAccessCardinality = (Long)node.getProperty((Object)NodeConstants.Info.EST_DEP_CARDINALITY)) != null) {
                processNode.setEstimateDepAccessCardinality(estimateDepAccessCardinality);
            }
            if ((estimateDepJoinCost = (Long)node.getProperty((Object)NodeConstants.Info.EST_DEP_JOIN_COST)) != null) {
                processNode.setEstimateDepJoinCost(estimateDepJoinCost);
            }
            if ((estimateJoinCost = (Long)node.getProperty((Object)NodeConstants.Info.EST_JOIN_COST)) != null) {
                processNode.setEstimateJoinCost(estimateJoinCost);
            }
            if ((hasSetCrits = (Boolean)node.getProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS)) != null && hasSetCrits.equals(Boolean.TRUE)) {
                DependentWaitNode waitNode = new DependentWaitNode(PlanToProcessConverter.getID(idGenerator));
                waitNode.setDependentCriteria(DependentSetCriteriaCollectorVisitor.getDependentSetCriteria((LanguageObject)possiblyDependentObject));
                processNode = PlanToProcessConverter.insertNode((RelationalNode)processNode, (RelationalNode)waitNode, cols, topCols, estimateNodeCardinality, estimateNodeSetSize, estimateDepAccessCardinality, estimateDepJoinCost, estimateJoinCost);
            }
            if ((depValueSource = (DependentValueSource)node.getProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE)) != null) {
                DependentFeederNode feederNode = new DependentFeederNode(PlanToProcessConverter.getID(idGenerator));
                feederNode.setDependentValueSource(depValueSource);
                processNode = PlanToProcessConverter.insertNode((RelationalNode)processNode, (RelationalNode)feederNode, cols, topCols, estimateNodeCardinality, estimateNodeSetSize, estimateDepAccessCardinality, estimateDepJoinCost, estimateJoinCost);
            }
        }
        return processNode;
    }

    private static RelationalNode insertNode(RelationalNode currentNode, RelationalNode insertedNode, List cols, List topCols, Integer estimateNodeCardinality, Integer estimateNodeSetSize, Long estimateDepAccessCardinality, Long estimateDepJoinCost, Long estimateJoinCost) {
        insertedNode.setElements(cols);
        insertedNode.setTopElements(topCols);
        insertedNode.setEstimateNodeCardinality(estimateNodeCardinality);
        insertedNode.setEstimateNodeSetSize(estimateNodeSetSize);
        insertedNode.setEstimateDepAccessCardinality(estimateDepAccessCardinality);
        insertedNode.setEstimateDepJoinCost(estimateDepJoinCost);
        insertedNode.setEstimateJoinCost(estimateJoinCost);
        insertedNode.addChild(currentNode);
        return insertedNode;
    }

    private static void buildSortedJoinInputs(PlanNode mergeJoinNode, QueryMetadataInterface metadata, JoinNode jnode) throws QueryPlannerException, MetaMatrixComponentException {
        PlanToProcessConverter.buildInputsSingleSide(mergeJoinNode, jnode, false);
        PlanToProcessConverter.buildInputsSingleSide(mergeJoinNode, jnode, true);
    }

    private static void buildInputsSingleSide(PlanNode mergeJoinNode, JoinNode jnode, boolean side) {
        boolean sortInAccess = false;
        List expressions = null;
        PlanNode accessNode = null;
        if (!side) {
            sortInAccess = (Boolean)mergeJoinNode.getProperty((Object)NodeConstants.Info.SORT_IN_LEFT_ACCESS);
            expressions = (List)mergeJoinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS);
            accessNode = mergeJoinNode.getFirstChild();
        } else {
            sortInAccess = (Boolean)mergeJoinNode.getProperty((Object)NodeConstants.Info.SORT_IN_RIGHT_ACCESS);
            expressions = (List)mergeJoinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS);
            accessNode = mergeJoinNode.getLastChild();
        }
        if (sortInAccess) {
            sortInAccess = PlanToProcessConverter.updateAccessNode(expressions, accessNode);
        }
        if (!sortInAccess) {
            PlanToProcessConverter.insertSortNode(expressions, mergeJoinNode, side);
        }
    }

    private static boolean updateAccessNode(List childExpressions, PlanNode childNode) {
        if (childNode.getType() != 3) {
            return false;
        }
        Command command = (Command)childNode.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
        if (command.getType() != 1) {
            return false;
        }
        QueryCommand query = (QueryCommand)command;
        if (query.getOrderBy() != null) {
            return false;
        }
        OrderBy orderBy = new OrderBy();
        orderBy.addVariables((Collection)childExpressions);
        query.setOrderBy(orderBy);
        return true;
    }

    private static void insertSortNode(List expressions, PlanNode jnode, boolean side) {
        PlanNode childNode = null;
        childNode = !side ? jnode.getFirstChild() : jnode.getLastChild();
        boolean hasFunctions = false;
        ArrayList<Object> orderSymbols = new ArrayList<Object>(expressions.size());
        ArrayList<ExpressionSymbol> projectSymbols = new ArrayList<ExpressionSymbol>();
        projectSymbols.addAll((List)childNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
        int exprID = 0;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = (Expression)expressions.get(i);
            if (expr instanceof ElementSymbol) {
                orderSymbols.add(expr);
                continue;
            }
            hasFunctions = true;
            ExpressionSymbol exprSymbol = new ExpressionSymbol("expr_" + exprID++, expr);
            orderSymbols.add(exprSymbol);
            projectSymbols.add(exprSymbol);
            expressions.set(i, exprSymbol);
        }
        if (hasFunctions) {
            PlanNode projectNode = NodeFactory.getNewNode((int)11);
            projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, projectSymbols);
            projectNode.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, projectSymbols);
            NodeEditor.insertNode(jnode, childNode, projectNode);
            childNode = projectNode;
        }
        PlanNode sortNode = NodeFactory.getNewNode((int)17);
        sortNode.setProperty((Object)NodeConstants.Info.SORT_ORDER, orderSymbols);
        ArrayList<Boolean> directions = new ArrayList<Boolean>(orderSymbols.size());
        for (int i = 0; i < orderSymbols.size(); ++i) {
            directions.add(OrderBy.ASC);
        }
        sortNode.setProperty((Object)NodeConstants.Info.ORDER_TYPES, directions);
        sortNode.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, projectSymbols);
        NodeEditor.insertNode(jnode, childNode, sortNode);
    }

    static boolean isAccessingTempGroup(Command command, QueryMetadataInterface metadata) throws QueryPlannerException, MetaMatrixComponentException {
        boolean REMOVE_DUPLICATES = true;
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
        if (groups.size() != 1) {
            return false;
        }
        GroupSymbol groupSymbol = (GroupSymbol)groups.iterator().next();
        Object groupID = groupSymbol.getMetadataID();
        try {
            return metadata.isTemporaryGroup(groupID);
        }
        catch (QueryMetadataException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0008", (Object)command));
        }
    }

    private static Criteria getJoinCriteria(PlanNode node) {
        List joinCrits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        if (joinCrits != null) {
            if (joinCrits.size() == 1) {
                return (Criteria)joinCrits.get(0);
            }
            if (joinCrits.size() > 1) {
                return new CompoundCriteria(0, joinCrits);
            }
        }
        return null;
    }

    private static String getRoutingName(PlanNode node, QueryMetadataInterface metadata) throws QueryPlannerException, MetaMatrixComponentException {
        try {
            Object modelID = node.getProperty((Object)NodeConstants.Info.MODEL_ID);
            if (modelID == null || modelID instanceof TempMetadataID) {
                Command command = (Command)node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                if (command instanceof StoredProcedure) {
                    modelID = ((StoredProcedure)command).getModelID();
                } else {
                    Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
                    Iterator groupIter = groups.iterator();
                    GroupSymbol group = (GroupSymbol)groupIter.next();
                    modelID = metadata.getModelID(group.getMetadataID());
                }
            }
            String cbName = metadata.getFullName(modelID);
            return cbName;
        }
        catch (QueryMetadataException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0009"));
        }
    }

    private static Command setAccessNodeCommand(AccessNode anode, PlanNode node, QueryMetadataInterface metadata) throws QueryPlannerException, MetaMatrixComponentException {
        Command command = (Command)node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
        anode.setCommand(command);
        anode.setModelName(PlanToProcessConverter.getRoutingName(node, metadata));
        try {
            anode.setShouldEvaluateExpressions(EvaluateExpressionVisitor.wouldChangeExpressions((LanguageObject)command, true, true));
        }
        catch (ExpressionEvaluationException e) {
            anode.setShouldEvaluateExpressions(true);
        }
        return command;
    }
}

