/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.anttask.adminapi;

import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.platform.client.ServerAdminFactory;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.installer.InstallerPlugin;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class BaseAdminAPITask
extends Task {
    private ServerAdmin targetAdminAPI;
    String user = "";
    String password = "";
    String hostname = "";
    int portnumber = -1;
    boolean usingSSL = false;
    boolean performDecryption = false;

    public void setHost(String host) {
        this.hostname = host;
    }

    public void setPort(int port) {
        this.portnumber = port;
    }

    public void setUsername(String name) {
        this.user = name;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setTurnondecryption(boolean turnoff) {
        this.performDecryption = turnoff;
    }

    protected ServerAdmin getAPI() {
        if (this.targetAdminAPI == null) {
            this.establishConnection();
        }
        return this.targetAdminAPI;
    }

    public void establishConnection() throws BuildException {
        if (this.password != null && this.performDecryption) {
            try {
                char[] newpw = CryptoUtil.stringDecrypt((char[])this.password.toCharArray());
                this.password = new String(newpw);
                this.getProject().log("Decrypting password", 2);
            }
            catch (Exception e) {
                String msg = InstallerPlugin.Util.getString("BaseAdminAPITask.Unable_to_decryptpassword");
                this.getProject().log(msg, 0);
                throw new BuildException(msg, (Throwable)e);
            }
        }
        try {
            this.usingSSL = SocketHelper.isServerSSLEnabled();
            this.getProject().log("Using SSL: " + this.usingSSL, 2);
        }
        catch (Exception e) {
            String msg = InstallerPlugin.Util.getString("BaseAdminAPITask.Unable_to_determine_is_ssl_enabled");
            this.getProject().log(msg, 0);
            throw new BuildException(msg, (Throwable)e);
        }
        MMURL url = null;
        try {
            url = new MMURL(this.hostname, this.portnumber, this.usingSSL);
            ServerAdminFactory factory = ServerAdminFactory.getInstance();
            this.targetAdminAPI = factory.createAdmin(this.user, this.password.toCharArray(), url.getAppServerURL());
        }
        catch (Exception err) {
            String msg = InstallerPlugin.Util.getString("BaseAdminAPITask.Unable_to_connect_to_server", (Object)(url != null ? url.getAppServerURL() : "nullurl"));
            this.getProject().log(msg, 0);
            throw new BuildException(msg, (Throwable)err);
        }
    }
}

